<?php

class Candidate extends CI_Controller
{
    public function index()
    {
        $data['title']='STUDENT LOGIN';
        //echo "Candidate Controller Index";
        $this->load->view('candidate/templates/candidate_index_header');
        $this->load->view('candidate/candidate_index',$data);
        $this->load->view('candidate/templates/candidate_index_footer');
 
    }

		//check if email exists	
		public function check_email_exists($email)
		{
			$this->form_validation->set_message('check_email_exists','That Email ID is taken. Please choose a different one');
			
			if($this->candidate_model->check_email_exists($email))
			{
				return true;
			}
			else
			{
				return false;
			}
		}

		//check if phone number exists	
		public function check_phone_exists($phone)
		{
			$this->form_validation->set_message('check_phone_exists','That Phone Number is taken. Please choose a different one');
			
			if($this->candidate_model->check_phone_exists($phone))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		//check if username exists	
		public function check_username_exists($username)
		{
			$this->form_validation->set_message('check_username_exists','That Username is taken. Please choose a different one');
			
			if($this->candidate_model->check_username_exists($username))
			{
				return true;
			}
			else
			{
				return false;
			}
		}


      public function login()
    {
        $data['title']='STUDENT LOGIN';
        
        //echo "this is candidate submitted form lets load the dashboard with session";

        $this->form_validation->set_rules('username','Username','required');
        $this->form_validation->set_rules('password','Password','required');

        if($this->form_validation->run()===FALSE)
        {
        $this->load->view('candidate/templates/candidate_index_header');
        $this->load->view('candidate/candidate_index',$data);
        $this->load->view('candidate/templates/candidate_index_footer');				
        }
        else
        {
            //get username from user
            $username=$this->input->post('username');
            //get password from user and encrypt for verification through model
            $password=$this->input->post('password');
            
            $candidate_pay_status=$this->candidate_model->retrive_payment_status($username,$password);
            $candidate_admission_no=$this->candidate_model->retrive_adm_no($username,$password);

            //login user , after successful login we will get user_id
            $candidate_id=$this->candidate_model->login($username,$password);
            
            
            //if user_id is valid then create the session
            if($candidate_id)
            {
                             //create session
                $candidate_data= array(			//passing data of user in array to be available throughout session
                    'candidate_id' =>$candidate_id,
                    'username' =>$username,
                    'admission_no'=>$candidate_admission_no,
                    'paid_status'=>$candidate_pay_status,
                    'logged_in' =>true
                );
                
                $this->session->set_userdata($candidate_data);//setting the user data array to the session
                //set flash message
                $this->session->set_flashdata('candidate_loggedin','You are now logged in');
                redirect('candidate/dashboard');//redirecting to the posts index page
                
            }
            else
            {
                //set flash message
                $this->session->set_flashdata('login_failed','Login is invalid');
                redirect('candidate/index');
                
            }
            
        }
        
    }

 
    public function forgot_password()
    {
        $data['title']='STUDENT LOGIN<br><span style="font-color:red;font-size:15px;">Forgot Password</span>';
       // echo "this is candidate forgot-password form lets load the email sending form";
       $this->load->view('candidate/templates/candidate_index_header');
       $this->load->view('candidate/candidate_forgotpassword',$data);
       $this->load->view('candidate/templates/candidate_index_footer');				

    }




    public function retrive_password()
    {
        $data['title']='STUDENT LOGIN<br><span style="font-color:red;font-size:15px;">Forgot Password</span>';
       // echo "candidate forgot password";
       $this->form_validation->set_rules('username','Username','required');
       $this->form_validation->set_rules('email','Email','required');

       if($this->form_validation->run()===FALSE)
       {
       $this->load->view('candidate/templates/candidate_index_header');
       $this->load->view('candidate/candidate_forgotpassword',$data);
       $this->load->view('candidate/templates/candidate_index_footer');
       }	
       else
       {
               //get username from user
               $username=$this->input->post('username');
                 //get phone number from user
                //$phone=$this->input->post('phone');
                //get password from user and encrypt for verification through model
               $email=$this->input->post('email');

               $candidate_email=$this->candidate_model->validate_username_email($username,$email);// 74.125.195.108//gsmtp.googlemail.com//tls://smtp.gmail.com//587
               $candidate_password=$this->candidate_model->retrive_password($username,$email);
                if($candidate_email)//https://mail.google.com
                {
                    //send email
                    //$config=Array('mailtype'=>'text','protocol'=>'sendmail','smtp_host'=>'74.125.195.108','smtp_port'=>'465','smtp_user'=>'vbpwebsoft@gmail.com','smtp_pass'=>'bmlpp9243@','charset'=>'iso-8859-1','newline'=>"\r\n",'smtp_crypto'=>'tls','validation'=>TRUE);
                    $config=Array('mailtype'=>'text','protocol'=>'SMTP','smtp_host'=>'mail.cafeonline.co.in','smtp_port'=>'465','smtp_user'=>'register@cafeonline.co.in','smtp_pass'=>'cafeonline@register','charset'=>'iso-8859-1','newline'=>"\r\n",'smtp_crypto'=>'tls','validation'=>TRUE);

                    $this->load->library('email',$config);
                    //$this->email->set_newline("\r\n");

                    $this->email->from('register@cafeonline.co.in', 'Cafe Online');//smtp_port=>465,587
                    $this->email->to($candidate_email);
                   // $this->email->cc('virbhadrapant@gmail.com');
                   // $this->email->bcc('them@their-example.com');

                    $this->email->subject('Cafeonline Login Credentials.');
                    $this->email->message('Your Email is:  '.$username.'  Your Password is:  '.$candidate_password);
                    $this->email->set_alt_message('$username');

                    //setting path to server root for storage 
                   // $path=$this->config->item('server_root');
                    //echo $path;die();
                    //$file=$path.'/onlinecafe/assets/attachment/yourinfo.txt';
                    //$this->email->attach($file);
                    



                    //sending message to the registered mobile





                    //checking if mail is sent
                    if($this->email->send())
                    {
                       // echo "ur email sent";
                       $this->session->set_flashdata('emailed_candidate','Check Your Registered Email.(Check your spam folder also.)');    
                       redirect('candidate/login'); 
   
                    }
                    else
                    {
                        show_error($this->email->print_debugger());
                    }
                    //$this->session->set_flashdata('emailed_candidate','Check Your Registered Email.(Check your spam folder also.)');    
                    //redirect('candidate/login'); 
                          
                            
                }
                else
                {
                    //set flash message
                    $this->session->set_flashdata('email_failed','Username-Email Pair is invalid');
                    redirect('candidate/forgot_password');
                    
                }
   
       }			

    }


    /*

    $candidate_data= array(			//passing data of user in array to be available throughout session
        'candidate_id' =>$candidate_id,
        'username' =>$username,
        'paid_status'=>false,
        'logged_in' =>true
    );
    $candidate_data=['session_id'=>'CO-001-CAN-18']

    */

    public function dashboard()
    {
       // echo "this is candidate dashboard";
       //$username=$this->session->userdata('username');
       if(isset($this->session->userdata['candidate_id']))
       {
       $this->load->view('candidate/templates/candidate_dashboard_header');
       $this->load->view('candidate/candidate_dashboard',$this->session->userdata);
       $this->load->view('candidate/templates/candidate_dashboard_footer');

      
          // $this->data['course_id'] = $this->session->userdata('course_id');
         // echo "good 1 veer";
       } 
       else
       {
           redirect('candidate/login');
       }

    }



    public function logout()
    {
       /* $candidate_data= array(			//passing data of user in array to be available throughout session
            'candidate_id' =>$candidate_id,
            'username' =>$username,
            'logged_in' =>true
             );
             */
        //Unset user data
       // $this->session->unset_userdata($candidate_data);
       // $this->session->unset_userdata('user_id');
        //$this->session->unset_userdata('username');
        
        //set flash message
        $this->session->set_flashdata('candidate_loggedout','You are now logged out');

        $this->session->unset_userdata('candidate_id');
        $this->session->unset_userdata('username');
        $this->session->unset_userdata('logged_in');
        $this->session->unset_userdata('admission_no');
        $this->session->unset_userdata('paid_status');

        redirect('candidate/login');
        $this->session->sess_destroy();
    }

 

  		//register new user
         public function signup()
         {
           // $this->load->library('image_lib');
            //$this->load->helper(array('captcha'));

           // $data=array(
             //   'img_path'  =>base_url('static/'),
            // 'img_url'   =>base_url('static'),
            //    'img_width' =>'150',
             //   'img_height'=>'30'
            // );

            //$captcha=create_captcha($data);
            //$this->load->view('home/signup/signup_main',$captcha);
             
            //echo "this is new student signup method";

             //$data['title']='CAFE ONLINE<br><span style="font-color:red;font-size:12px;">New Student Registration</span>';
             
             //$data['post']=$this->post_model->get_posts($slug);
 
             $this->form_validation->set_rules('firstname','First Name','required');
             $this->form_validation->set_rules('lastname','Last Name','required');
             $this->form_validation->set_rules('email','Email ID','required|callback_check_email_exists');
             $this->form_validation->set_rules('phone','Phone Number','required|callback_check_phone_exists');
             $this->form_validation->set_rules('username','Username','required|callback_check_username_exists');
             $this->form_validation->set_rules('password','Password','required');
             $this->form_validation->set_rules('password1','Confirm Password','required','matches[password]');
             $this->form_validation->set_rules('gender','Gender','required');
 
             if($this->form_validation->run()===FALSE)
             {
             $this->load->view('home/signup/templates/signup_header');
             $this->load->view('home/signup/signup_main');
             $this->load->view('home/signup/templates/signup_footer');				
             }
             else
             {
                 //Encrypting password 
                 $enc_password=md5($this->input->post('password'));
                 $admission_no=random_string('basic',9);
                 if( $this->candidate_model->register($enc_password,$admission_no))
                {
                            //candidates credentials
                            $candidate_email=$this->input->post('email');
                            $candidate_phone=$this->input->post('phone');
                            $username=$this->input->post('username');
                            $candidate_password=$this->input->post('password');
                            //send email
                            //$config=Array('mailtype'=>'text','protocol'=>'sendmail','smtp_host'=>'74.125.195.108','smtp_port'=>'465','smtp_user'=>'vbpwebsoft@gmail.com','smtp_pass'=>'bmlpp9243@','charset'=>'iso-8859-1','newline'=>"\r\n",'smtp_crypto'=>'tls','validation'=>TRUE);
                            $config=Array('mailtype'=>'text','protocol'=>'SMTP','smtp_host'=>'mail.cafeonline.co.in','smtp_port'=>'465','smtp_user'=>'register@cafeonline.co.in','smtp_pass'=>'cafeonline@register','charset'=>'iso-8859-1','newline'=>"\r\n",'smtp_crypto'=>'tls','validation'=>TRUE);
                            $this->load->library('email',$config);
                            //$this->email->set_newline("\r\n");

                            $this->email->from('register@cafeonline.co.in', 'Cafe Online');//smtp_port=>465,587
                            $this->email->to($candidate_email);
                            // $this->email->cc('virbhadrapant@gmail.com');
                            // $this->email->bcc('them@their-example.com');

                            $this->email->subject('Cafeonline Login Credentials.');
                            $this->email->message('Your Username is:  '.$username.'  Your Password is:  '.$candidate_password);
                            //$this->email->set_alt_message('$username');

                            //setting path to server root for storage 
                             // $path=$this->config->item('server_root');
                            //echo $path;die();
                            //$file=$path.'/onlinecafe/assets/attachment/yourinfo.txt';
                            //$this->email->attach($file);


                            /***************************SENDING MESSAGE TO MOBILE*************************
                            //sending message to the phone
                           // $candidate_credential='"Your Username is:  ".$username."  Your Password is:  ".$candidate_password';
                            //$msg=urlencode($candidate_credential);
                            $msg='"Your Username is:  ".$username."  Your Password is:  ".$candidate_password';
                            
                            $authintication_key="";
                            $sender_id="SMSHUB";
                            $route= "";
                            $postData=array(
                                'authkey'=>$authintication_key,
                                'mobiles'=> $candidate_phone,
                                'message'=>$msg,
                                'sender'=>$sender_id,
                                'route'=>$route
                            );
                            $url="http://cloud.smsindiahub.in/vendorsms/pushsms.aspx";//"http://api.xyx.com";
                            $ch=curl_init();
                            curl_setopt_array($ch,array(
                                CURLOPT_URL=>$url,
                                CURLOPT_RETURNTRANSFER=>TRUE,
                                CURLOPT_POST=>TRUE,
                                CUROPT_POSTFIELDS=>$postData
                            ));
                            //message sending process
                            curl_setopt($ch,CURLOPT_SSL_VERIFYHOST,0);
                            curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,0);
                            //saving output
                            $output=curl_exec($ch);
                            //checking for errors
                            if(curl_error($ch))
                            {
                                echo 'error'.curl($ch);
                            }
                            //closing curl
                            curl_close($ch);
                            ?>
                            <!--saving response-->
                            <p>Response ID:<?php echo $output; ?> Message Sent Successfully</p>
                            <?php

                            ************************************SENDING MESSAGE TO MOBILE*******/

                            //checking if mail is sent
                            if($this->email->send())
                            {
                                // echo "ur email sent";
                                
                                //setting the session
                                $candidate_pay_status=$this->candidate_model->retrive_payment_status($username,$candidate_password);
                                $candidate_admission_no=$this->candidate_model->retrive_adm_no($username,$candidate_password);

                                $candidate_id=$this->candidate_model->login($username,$candidate_password);
                                if($candidate_id)
                                {
                                                 //create session
                                    $candidate_data= array(			//passing data of user in array to be available throughout session
                                        'candidate_id' =>$candidate_id,
                                        'username' =>$username,
                                        'admission_no'=>$candidate_admission_no,
                                        'paid_status'=>$candidate_pay_status,
                                        'logged_in' =>true
                                    );
                                    
                                    $this->session->set_userdata($candidate_data);//setting the user data array to the session
                                    //set flash message                          
                                    $this->session->set_flashdata('candidate_registered','You are now registered and can log in using your credentials sent at your provided Email ID(Check Spam folder also)');
                                    redirect('candidate/dashboard');
                                    
                                }
                                else
                                {
                                    //set flash message
                                    $this->session->set_flashdata('login_failed','Login is invalid');
                                    redirect('candidate/index');
                                    
                                }




        
                            }
                            else
                            {
                                echo "Candidate Registered but mail not sent";
                                show_error($this->email->print_debugger());
                            }


  
                }
                else
                {
                    $this->session->set_flashdata('candidate_reg_failed','Registration failed due to some technical reasons. Try again.');
                    redirect('candidate/login');   
                }
                 
               }
             
         }
 


}