<?php

class Instructor extends CI_Controller
{


    public function index()
    {
    $data['title']='STAFF LOGIN';
     //echo "Instructor Controller Index";
     $this->load->view('instructor/templates/instructor_index_header');
     $this->load->view('instructor/instructor_index',$data);
     $this->load->view('instructor/templates/instructor_index_footer');
 
    }




    public function login()
    {
        $data['title']='STAFF LOGIN';
        
        //echo "this is instructor submitted form lets load the dashboard with session";

        $this->form_validation->set_rules('username','Username','required');
        $this->form_validation->set_rules('password','Password','required');

        if($this->form_validation->run()===FALSE)
        {
        $this->load->view('instructor/templates/instructor_index_header');
        $this->load->view('instructor/instructor_index',$data);
        $this->load->view('instructor/templates/instructor_index_footer');				
        }
        else
        {
            //get username from user
            $username=$this->input->post('username');
            //get password from user and encrypt for verification through model
            $password=$this->input->post('password');
            
            //login user , after successful login we will get user_id
            $instructor_id=$this->instructor_model->login($username,$password);
            

            $firstname=$this->instructor_model->retrive_fname($username,$password);
            $lastname=$this->instructor_model->retrive_lname($username,$password);
            $email_id=$this->instructor_model->retrive_email($username,$password);

            //if user_id is valid then create the session
            if($instructor_id)
            {
    			//create session
                $instructor_data= array(			//passing data of user in array to be available throughout session
                       'instructor_id' =>$instructor_id,
                       'username' =>$username,
                       'firstname' =>$firstname,
                       'lastname' =>$lastname,
                       'email_id' =>$email_id,
                       'logged_in' =>true
                        );
                        
                $this->session->set_userdata($instructor_data);//setting the user data array to the session
            
            //echo "load instructors' dashboard:  $username";  
            //echo "<br>";
            //echo $password; 
                $this->session->set_flashdata('instructor_loggedin','You are now logged in');    
                redirect('instructor/dashboard');         
            }
            else
            {
                //set flash message
                $this->session->set_flashdata('login_failed','Login is invalid');
                redirect('instructor/index');
                
            }
            
        }
        
    }



    public function forgot_password()
    {
        $data['title']='STAFF LOGIN<br><span style="font-color:red;font-size:15px;">Forgot Password</span>';
       // echo "Instructor forgot password";
       $this->load->view('instructor/templates/instructor_index_header');
       $this->load->view('instructor/instructor_forgotpassword',$data);
       $this->load->view('instructor/templates/instructor_index_footer');				

    }

    public function retrive_password()
    {
        $data['title']='STAFF LOGIN<br><span style="font-color:red;font-size:15px;">Forgot Password</span>';
       // echo "Instructor forgot password";
       $this->form_validation->set_rules('username','Username','required');
       $this->form_validation->set_rules('email','Email','required');

       if($this->form_validation->run()===FALSE)
       {
       $this->load->view('instructor/templates/instructor_index_header');
       $this->load->view('instructor/instructor_forgotpassword',$data);
       $this->load->view('instructor/templates/instructor_index_footer');
       }	
       else
       {
               //get username from user
               $username=$this->input->post('username');
               //get password from user and encrypt for verification through model
               $email=$this->input->post('email');

               $instructor_email=$this->instructor_model->validate_username_email($username,$email);// 74.125.195.108//gsmtp.googlemail.com//tls://smtp.gmail.com//587
               $instructor_password=$this->instructor_model->retrive_password($username,$email);
                if($instructor_email)//https://mail.google.com
                {
                    //send email
                    //$config=Array('mailtype'=>'text','protocol'=>'sendmail','smtp_host'=>'74.125.195.108','smtp_port'=>'465','smtp_user'=>'vbpwebsoft@gmail.com','smtp_pass'=>'bmlpp9243@','charset'=>'iso-8859-1','newline'=>"\r\n",'smtp_crypto'=>'tls','validation'=>TRUE);
                    $config=Array('mailtype'=>'text','protocol'=>'SMTP','smtp_host'=>'mail.cafeonline.co.in','smtp_port'=>'465','smtp_user'=>'register@cafeonline.co.in','smtp_pass'=>'cafeonline@register','charset'=>'iso-8859-1','newline'=>"\r\n",'smtp_crypto'=>'tls','validation'=>TRUE);

                    $this->load->library('email',$config);
                    //$this->email->set_newline("\r\n");

                    $this->email->from('register@cafeonline.co.in', 'Cafe Online');//smtp_port=>465,587
                    $this->email->to($instructor_email);
                   // $this->email->cc('virbhadrapant@gmail.com');
                   // $this->email->bcc('them@their-example.com');

                    $this->email->subject('Cafeonline Login Credentials.');
                    $this->email->message('Your Email is:  '.$username.'  Your Password is:  '.$instructor_password);
                    $this->email->set_alt_message('$username');

                    //setting path to server root for storage 
                   // $path=$this->config->item('server_root');
                    //echo $path;die();
                    //$file=$path.'/onlinecafe/assets/attachment/yourinfo.txt';
                    //$this->email->attach($file);

                    //checking if mail is sent
                    if($this->email->send())
                    {
                        //echo "ur email sent";
                        $this->session->set_flashdata('emailed_instructor','Check Your Registered Email.(Check your spam folder also.)');    
                        redirect('instructor/login'); 
    
                    }
                    else
                    {
                        show_error($this->email->print_debugger());
                    }
                    //$this->session->set_flashdata('emailed_instructor','Check Your Registered Email.(Check your spam folder also.)');    
                    //redirect('instructor/login'); 
                          
                            
                }
                else
                {
                    //set flash message
                    $this->session->set_flashdata('email_failed','Username-Email Pair is invalid');
                    redirect('instructor/forgot_password');
                    $this->session->sess_destroy();
                    
                }
   
       }			

    }






 
    public function dashboard()
    {
        // echo "this is instructor dashboard";
        //$username=$this->session->userdata('username');
        if(isset($this->session->userdata['instructor_id']))
        {
            $this->load->view('instructor/templates/instructor_dashboard_header');
            $this->load->view('instructor/instructor_dashboard',$this->session->userdata);
            $this->load->view('instructor/templates/instructor_dashboard_footer');
        } 
        else
        {
            redirect('instructor/login');
        }

    }



    public function logout()
    {
       /* $instructor_data= array(			//passing data of user in array to be available throughout session
            'instructor_id' =>$instructor_id,
            'username' =>$username,
            'logged_in' =>true
             );
             */
        //Unset user data
       // $this->session->unset_userdata($instructor_data);
       // $this->session->unset_userdata('user_id');
        //$this->session->unset_userdata('username');
        
        //set flash message
        $this->session->set_flashdata('instructor_loggedout','You are now logged out');

        $this->session->unset_userdata('instructor_id');
        $this->session->unset_userdata('username');
        $this->session->unset_userdata('firstname');
        $this->session->unset_userdata('lastname');
        $this->session->unset_userdata('email_id');
        $this->session->unset_userdata('logged_in');


        redirect('instructor/login');
        $this->session->sess_destroy();
    }

 
}