<?php

class Humanresource_model extends CI_Model
{
  
    public function get_employee($emp_id=FALSE)
    {
        if($emp_id===FALSE)
        {
            $query=$this->db->get('tbl_employee');
            return $query->result_array();
        }  			
        $query=$this->db->get_where('tbl_employee',array('emp_id'=>$emp_id));
        return $query->row_array();
    }


    public function get_terminated_employee($emp_id=FALSE)
    {
        if($emp_id===FALSE)
        {
            $query=$this->db->get('tbl_terminated_emp');
            return $query->result_array();
        }  			
        $query=$this->db->get_where('tbl_terminated_emp',array('emp_id'=>$emp_id));
        return $query->row_array();
    }

    

    public function get_stakeholder_type_code_by_type($stakeholder_type)
    { 			
        $query=$this->db->get_where('tbl_stakeholders',array('stakeholder_type'=>$stakeholder_type));
        return $query->row_array()['type_code'];
    }

    public function get_stakeholder_type_code($stakeholder_id=FALSE)
    {
        if($stakeholder_id===FALSE)
        {
            $query=$this->db->get('tbl_stakeholders');
            return $query->result_array();
        }  			
        $query=$this->db->get_where('tbl_stakeholders',array('stakeholder_id'=>$stakeholder_id));
        return $query->row_array();
    }

    public function get_departments($dept_id=FALSE)
    {
        if($dept_id===FALSE)
        {
            $query=$this->db->get('tbl_department');
            return $query->result_array();
        }  			
        $query=$this->db->get_where('tbl_department',array('id'=>$dept_id));
        return $query->row_array();

    }


    public function get_designations($deg_id=FALSE)
    {
        if($deg_id===FALSE)
        {
            $query=$this->db->get('tbl_designation');
            return $query->result_array();
        }  			
        $query=$this->db->get_where('tbl_designation',array('id'=>$deg_id));
        return $query->row_array();

    }


    	//check username exists
		public function check_username_exists($username)
		{
			$query=$this->db->get_where('tbl_employee',array('username'=>$username));
			
			if(empty($query->row_array()))
			{
				return true;
			}
			else
			{
				return false;
			}
			return $query->row();
		}

		//check email exists
		public function check_email_exists($email)
		{
			$query=$this->db->get_where('tbl_employee',array('email_id'=>$email));
			
			if(empty($query->row_array()))
			{
				return true;
			}
			else
			{
				return false;
			}
			return $query->row();
        }
        
		//check phone exists
		public function check_phone_exists($phone)
		{
			$query=$this->db->get_where('tbl_employee',array('phone_no'=>$phone));
			
			if(empty($query->row_array()))
			{
				return true;
			}
			else
			{
				return false;
			}
			return $query->row();
		}


        public function retrive_emp_password($username,$email)
        {
            //$this->load->database;
            $this->db->where('username',$username);
            $this->db->where('email_id',$email);
            
            $result=$this->db->get('tbl_employee');
            
            if($result->num_rows()==1)
            {
                return $result->row(0)->password;
            }
            else
            {
                return false;
            }
        }
        
    
public function create_new_employee($emp_pword,$emp_profile_pic,$emp_photo_data,$emp_id)
{
    $data=array(
        'stakeholder_type'=>$this->input->post('stakeholder_type'),
        'emp_id'=>$emp_id,
        'firstname'=>$this->input->post('fname'),
        'lastname'=>$this->input->post('lname'),
        'gender'=>$this->input->post('gender'),
        'profile_photo'=>$emp_profile_pic,
        'profile_photo_data'=>$emp_photo_data,
        'email_id'=>$this->input->post('email'),
        'phone_no'=>$this->input->post('phone'),
        'username'=>$this->input->post('username'),
        'password'=>$emp_pword,
        'emp_status'=>$this->input->post('status'),
        'emp_remarks'=>$this->input->post('remarks'),
        'recruited_by'=>"HR-".$this->session->userdata['hr_id']
    );
    //insert user
    return $this->db->insert('tbl_employee',$data);

}

public function update_employee($employee_id,$employee_fname,$employee_lname,$employee_gender,$employee_status,$employee_remarks)
{
    $data1=array(
        'firstname'=>$employee_fname,
        'lastname'=>$employee_lname,
        'gender'=>$employee_gender,
        'emp_status'=>$employee_status,
        'emp_remarks'=>$employee_remarks
    );
    $this->db->where('emp_id',$employee_id);
    return $this->db->update('tbl_employee',$data1);
}

public function get_employee_search_result($search_item)
{
    $this->db->like('tbl_employee.emp_id', $search_item,'both');
    
    $this->db->or_like('tbl_employee.username', $search_item,'both');
    $this->db->or_like('tbl_employee.firstname', $search_item,'both');
    $this->db->or_like('tbl_employee.lastname', $search_item,'both');
    $this->db->or_like('tbl_employee.gender', $search_item,'both');
    $this->db->or_like('tbl_employee.email_id', $search_item,'both');
    $this->db->or_like('tbl_employee.phone_no', $search_item,'both');
    $this->db->or_like('tbl_employee.profile_photo', $search_item,'both');
    $this->db->or_like('tbl_employee.emp_status', $search_item,'both');
    $this->db->or_like('tbl_employee.emp_remarks', $search_item,'both');
    $this->db->or_like('tbl_employee.recruited_by', $search_item,'both');
    $this->db->or_like('tbl_employee.emp_create_time', $search_item,'both');

    $query=$this->db->get('tbl_employee');
    return $query->result_array();    
}

public function make_active_employee($employee_id)
{
    $data1=array(
        'emp_status'=>'active'
    );
    $this->db->where('emp_id',$employee_id);
    return $this->db->update('tbl_employee',$data1);  
}

public function make_inactive_employee($employee_id)
{
    $data1=array(
        'emp_status'=>'inactive'
    );
    $this->db->where('emp_id',$employee_id);
    return $this->db->update('tbl_employee',$data1);  
}


public function terminate_employee($employee_id,$termination_remark)
{
    $old_emp=$this->get_employee($employee_id);

    $data=array(
        'stakeholder_type'=>$old_emp['stakeholder_type'],
        'emp_id'=>$old_emp['emp_id'],
        'firstname'=>$old_emp['firstname'],
        'lastname'=>$old_emp['lastname'],
        'gender'=>$old_emp['gender'],
        'profile_photo'=>$old_emp['profile_photo'],
        'profile_photo_data'=>$old_emp['profile_photo_data'],
        'email_id'=>$old_emp['email_id'],
        'phone_no'=>$old_emp['phone_no'],
        'username'=>$old_emp['username'],
        'password'=>$old_emp['password'],
        'emp_status'=>$old_emp['emp_status'],
        'emp_remarks'=>$old_emp['emp_remarks'],
        'recruited_by'=>$old_emp['recruited_by'],
        'termination_remark'=>$termination_remark,
        'terminated_by'=>"HR-".$this->session->userdata['hr_id'],
        'emp_create_time'=>$old_emp['emp_create_time']
    );
    //insert user
    if($this->db->insert('tbl_terminated_emp',$data)):
        $this->db->where('emp_id', $employee_id);
        $this->db->delete('tbl_employee');
        return TRUE;
    else: 
        return FALSE;
    endif;

}






}