<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Dashboard extends CI_Controller {

	public function __construct (){
        parent::__construct();

        $this->data['page_name'] = "Dashboard";        
        $this->load->model('user_notes_model');
        $this->data['user_note_list'] = $this->user_notes_model->get();
        
        
    }
	
	public function index()
	{
		$this->load->view('dashboard',$this->data);
	}

	public function user_notes()
	{
            //Validation
            $this->data['title'] = "User Notes";
            $this->form_validation->set_rules(array(
            array(
                'field' => 'user_notes',
                'label' => 'Notes',
                'rules' => 'required',
                'errors' => array(
                        'required' => '%s cannot be blank.',
                ),
            ),
        ));
        //Insert
	if($this->form_validation->run() === true){
            if($this->user_notes_model->insert()){
                set_alert('success' ,'New Notes Created Successfully.' );
                redirect('dashboard/user_notes','refresh');
            } else {
                set_alert('error' , 'Error While Creating Notes.');
            }
        }        
        //Load Views
		$this->load->view('dashboard',$this->data);
        $this->load->view('user_notes/create',$this->data);
        $this->load->view('user_notes/index',$this->data);		
	}

	public function user_notes_edit()
	{
		$this->data['title'] = "User Notes";
		$this->data['user_notes'] = $this->user_notes_model->get($this->input->post('edit_id'));
		$this->index();
                $this->load->view('user_notes/edit',$this->data);
                $this->load->view('user_notes/index',$this->data);
	}

	public function user_notes_update(){
	    $this->data['title'] = "User Notes";
            if($this->user_notes_model->update()){
                set_alert('success' ,'Notes updated Successfully.' );
                redirect('dashboard/user_notes');
            } else {
                set_alert('error' , 'Error While editing Notes.');
            }
    }

    public function user_notes_delete(){
	$this->data['title'] = "User Notes";
        if( $this->user_notes_model->delete($this->input->post('delete_id')) ){
            set_alert('success','Notes deleted successfully.');
        } else {
            set_alert('error','Error while deleting Notes.');
        }
        redirect('dashboard/user_notes');
    }



}
