<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Exam_Org extends CI_Controller{
    public function __construct() {
        parent::__construct();
        
        $this->data['page_name'] = "Exam Organization";
        $this->load->model('exam_org_model','eo_model');
        $this->load->model('exam_standard_model','es_model');
        
        $this->data['exam_standards'] = $this->es_model->get();     
    }
    
    public function index(){        
        $this->data['exam_organizations'] = $this->eo_model->get();
        $this->load->view('exam_org/index',$this->data);
    }
    
    public function create(){
        $this->form_validation->set_rules(array(
            array(
                'field' => 'exam_org',
                'label' => 'Exam Organization',
                'rules' => 'required',
                'errors' => array(
                        'required' => '%s cannot be left blank.',
                )
            ),
            array(
                'field' => 'exam_standard_ID',
                'label' => 'Exam Standard',
                'rules' => 'required',
                'errors' => array(
                        'required' => 'Please select an %s.',
                )
            )
       ));
        if($this->form_validation->run() === true){
            if($this->eo_model->insert()){
                set_alert('success' ,'New Exam Organization Created Successfully.' );
                redirect('exam_org','refresh');
            } else {
                set_alert('error' , 'Error While Creating Exam Organization.');
            }
        }
        $this->load->view('exam_org/create',$this->data);
    }
    
    public function edit(){
        $this->data['exam_orgs'] = $this->eo_model->get($this->input->post('edit_id'));
        $this->load->view('exam_org/edit',$this->data);
    }
    
    public function update(){       
         
       if($this->eo_model->update()){
           set_alert('success' ,'Exam Organization Updated Successfully.' );
           redirect('exam_org','refresh');
       } else {
           set_alert('error' , 'Error While Updating Exam Organization.');
       }      
  }
  
   public function delete(){
       
        if( $this->eo_model->delete($this->input->post('delete_id')) ){
            set_alert('success','Exam Organization deleted successfully.');
        } else {
            set_alert('error','Error while deleting Exam Organization.');
        }             
        redirect('exam_org');
    }
  
}

