<?php defined('BASEPATH') || exit('No direct script access allowed.');

/**
* User Resource Controller
*/
class User_Resource extends CI_Controller
{
	
	function __construct()
	{
		parent::__construct();

		$this->data['page_name'] = "User Resource";

		/**
		 *Loading Models
		 */
		$this->load->model('user_resource_model');
		$this->load->model('user_role_model');

		$this->data['user_roles'] = $this->user_role_model->get();
	}

	public function index()
	{
		$this->data['user_resources'] = $this->user_resource_model->get();
		$this->load->view('user_resource/index',$this->data);
	}

	public function create()
	{
		$this->form_validation->set_rules(array(
            array(
                'field' => 'user_role',
                'label' => 'User Role',
                'rules' => 'required',
                'errors' => array(
                        'required' => 'You must select %s.',
                ),
            ),
            array(
            	'field'	=> 'user_resource_type_name',
            	'label'	=> 'User Resource Type Name',
            	'rules' => 'required',
            	'errors' => array(
            		'required' => '%s cannot be left blank',
            	)
            )
        ));
        if($this->form_validation->run()==TRUE){
        	if($this->user_resource_model->insert()) {
        		set_alert('success','New User Resource created successfully.');
        		redirect(base_url('user_resource'));
        	} else {
        		set_alert('error','Error while creating New User Resource');
        	}
        }
		$this->load->view('user_resource/create',$this->data);
	}

	public function edit()
	{
		$this->data['user_resource'] = $this->user_resource_model->get($this->input->post('edit_id'));
		$this->load->view('user_resource/edit', $this->data);
	}

	public function update()
	{
		if($this->user_resource_model->update())
		{
			set_alert('success','User Resource updated successfully.');
		} else {
			set_alert('error', 'Error while updating User Resource.');
		}
		redirect(base_url('user_resource'));
	}

	public function delete()
	{
		if($this->user_resource_model->delete($this->input->post('delete_id'))){
			set_alert('success', 'User Resource deleted successfully.');
		} else {
			set_alert('error', 'Error while deleting User Resource.');
		}
		redirect(base_url('user_resource'));
	}
}