<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class OES_Auth 
{
	public $CI;

	public function __construct()
	{
		$this->CI = & get_instance();
	}

	public function checkAuthenticatedUser()
	{
		if(current_page_url()=='' || current_page_url() == 'login'){
			if($this->CI->auth->user()){
				redirect(base_url('dashboard'));
			}
		} else {
			if(!$this->CI->auth->user()){
				redirect(base_url('login'));
			}
		}
	}

	public function checkAccessPermissions()
	{
		if($this->CI->auth->user()) {

			if($this->CI->uri->segment(1) == 'online_exam'){
				return true;
			}
			
			$requested_page = $this->CI->db->get_where('page',array('page_url'=>current_page_url()))->row();
		
			if(!$this->CI->auth->allowed_page_access($requested_page)){
				show_error('You have no permissions to access this page.','403','403 - Unauthorized Access');
			}
		}
	}
}