<?php defined("BASEPATH") || exit('No direct script acces allowed.');

class Online_Exam_Model extends CI_Model 
{
    function __construct()
    {
        parent::__construct();
    }

    public function createQuestionPallete($exam_question_pool)
    {
        $questions = '';
		foreach($exam_question_pool as $subject => $pool){
			$questions .= implode(',',$exam_question_pool[$subject]) . ',';
		}
        return explode(',',rtrim($questions,','));
    }

    public function getQuestionsFromDB ($exam_question_pool)
    {
        $questions_data = array();

        foreach($exam_question_pool as $subject => $questions_array){
            $query = $this->db->select('*')
                                ->where_in('question_ID', $questions_array)
                                ->order_by('FIELD(question_ID,'.implode(',',$questions_array).')')
                                ->get('questions');

            $questions_data[$subject] = $query->result();
        }
        
        return $questions_data; 
    }
    
    public function getAnswersFromDB ($exam_question_pool)
    {
        $query = $this->db->select('answer_ID, question_ID, answer_content_en, answer_content_hin')
                ->where_in('question_ID', $exam_question_pool)
                ->get('answers');
        return $query->result();
    }

    public function getParagraphsFromDB ($exam_question_pool)
    {
        $paragraph_ids = $this->db->select('paragraph_ID')
                                ->distinct()
                                ->where('paragraph_ID !=', NULL)
                                ->where_in('question_ID', $exam_question_pool)
                                ->get('questions')->result_array();
        $paragraph_ids_array = array();
        foreach($paragraph_ids as $id) {
            $paragraph_ids_array[] = $id['paragraph_ID'];
        }
        

        $query = $this->db->select('*')
                        ->where('resource_type','paragraph')
                        ->where_in('question_resource_ID',$paragraph_ids_array)
                        ->get('question_resource');

        return $query->result();
    }

    public function getSubscribedExamStandards($user_ID)
    {
        $subscribed_subscription_packs = $this->db->select('*')
                                                ->where('user_ID',$user_ID)
                                                ->join('subscription_packs','subscription.subscription_pack_ID = subscription_packs.subscription_pack_ID')
                                                ->get('subscription')->result();

        $subscribed_exam_standards = '';

        if(!empty($subscribed_subscription_packs)){
            foreach($subscribed_subscription_packs as $pack){
                $subscribed_exam_standards .= $pack->exam_standards .',';
            }
        }

        if($subscribed_exam_standards != '') {
            $subscribed_exam_standards = explode(',',rtrim($subscribed_exam_standards,','));
        } else {
            $subscribed_exam_standards = array();
        }

        return $this->db->select('*')
                        ->where_in('exam_standard_ID',$subscribed_exam_standards)
                        ->get('exam_standard')->result();
    }

    public function getExamOrgsofExamStandards($exam_standards)
    {
        $exam_standard_IDs = array();
        foreach($exam_standards as $standard){
            $exam_standard_IDs[] = $standard->exam_standard_ID;
        }

        return $this->db->select('*')
                            ->where_in('exam_standard_ID',$exam_standard_IDs)
                            ->get('exam_org')->result();
    }

    public function getPostLevelsofExamOrgs($exam_orgs)
    {
        $exam_org_IDs = array();

        foreach($exam_orgs as $org){
            $exam_org_IDs[] = $org->exam_org_ID;
        }

        return $this->db->select('*')
                            ->where_in('exam_org_ID',$exam_org_IDs)
                            ->get('post_level')->result();
    }

    public function getSubjects()
    {
        $ongoing_exam_config = $this->session->userdata('ongoing_exam_config');

        $exam_config = $this->db->get_where('exam_config', array(
													'exam_standard_ID' 	=> $ongoing_exam_config['exam_standard'],
													'exam_org_ID' 		=> $ongoing_exam_config['exam_org'],
													'post_level_ID' 	=> $ongoing_exam_config['post_level']
													))->row();
        $subject_ids = array_keys(unserialize($exam_config->subjects));

        $query = $this->db->where_in('subject_ID',$subject_ids)
                        ->get('subject');

        return $query->result(); 
    }

}