<?php defined('BASEPATH') || exit('No direct script access allowed.');

/**
* Questions_Model
*/
class Questions_Model extends CI_Model
{
	public $table = 'questions';

	protected $ques_level = array(
		'1' => 'Beginner',
		'2' => 'Intermediate',
		'3'	=> 'Expert'
		);
	
	function __construct()
	{
		parent::__construct();
	}

	public function insert($paragraph_ID)
	{
		$data = array(
			'exam_standard_ID'		=> $this->input->post('exam_standard'),
			'exam_org_ID'			=> $this->input->post('exam_org'),
			'post_level_ID'			=> $this->input->post('post_level'),
			'question_level'		=> $this->input->post('ques_level'),
			'subject_ID'			=> $this->input->post('subject'),
			'question_content_en' 	=> $this->input->post('ques_content_en'),
			'question_content_hin' 	=> $this->input->post('ques_content_hin'),
			'explanation_en' 		=> $this->input->post('explanation_en'),
			'explanation_hin' 		=> $this->input->post('explanation_hin'),
			'marks'					=> $this->input->post('marks'),
			'paragraph_ID'			=> $paragraph_ID
		);

		if($this->db->insert($this->table, $data)){
			return $this->db->insert_id();
		}
		return false;
	}

	public function get($question_id=null)
	{
		if($question_id!==NULL){
			$query = $this->db->get_where($this->table,array('question_ID'=> $question_id));
			return $query->row();
		}
		$this->db->order_by('question_ID', 'DESC');
		$query = $this->db->get($this->table);
		return $query->result();
	}

	public function getQuesLevel()
	{
		return $this->ques_level;
	}

	public function update($paragraph_id)
	{
		$data = array(
			'exam_standard_ID'		=> $this->input->post('exam_standard'),
			'exam_org_ID'			=> $this->input->post('exam_org'),
			'post_level_ID'			=> $this->input->post('post_level'),
			'question_level'		=> $this->input->post('ques_level'),
			'subject_ID'			=> $this->input->post('subject'),
			'question_content_en' 	=> $this->input->post('ques_content_en'),
			'question_content_hin' 	=> $this->input->post('ques_content_hin'),
			'explanation_en' 		=> $this->input->post('explanation_en'),
			'explanation_hin' 		=> $this->input->post('explanation_hin'),
			'marks'					=> $this->input->post('marks'),
			'paragraph_ID'			=> $paragraph_id
		);


		$this->db->where('question_ID',$this->input->post('question_id'));
		return $this->db->update($this->table, $data);
	}

	public function delete($question_id)
	{
		return $this->db->delete($this->table, array('question_ID'=>$question_id));
	}


}