<!DOCTYPE html>
<html ng-app="exam-App">
<head>
	<title>ONLINE EXAM</title>
	<link rel="stylesheet" href="<?= base_url('assets/css/exam.css'); ?>">
	<script>
		var baseUrl = '<?= base_url(); ?>';
	</script>
</head>
<body>
<div class="main-container">
	<div class="header">
		<h1 class="app-title">Online Exam</h1>
	</div>
	<div class="main-section">
		<div class="left-section float-left">
			<div class="subjects float-left" ng-controller="subjectsCtrl">
				<h3 style="padding: 0 20px; margin: 10px 0;">Subjects : </h3>
				<ul class="subjects-list float-left">
					<li ng-repeat="subject in subjects"><a ng-click="selectSubject(subject.subject_ID)" class="btn">{{ subject.subject_name }}</a></li>
				</ul>
			</div>
			<div class="exam-area float-left" ng-controller="examCtrl" >
				<div class="paragraph-area" ng-show="hasParagraph">
					<div ckeditor="ckeditorOptions" ng-model="paragraph.resource_content_en" ready="onCKEditorReady()" contenteditable="true">
					</div>
				</div>
				<div class="question-area" ng-class="hasParagraph?'':'full-width'">
					<div ckeditor="ckeditorOptions" ng-model="question.question_content_en" ready="onCKEditorReady()" contenteditable="true">
					</div>
					<div class="answers-area">
					<ul>
						<h4 style="margin: 10px 0;">Answers :</h4>
						<li ng-repeat="(index, answer) in answers">
							{{index + 1}})&nbsp;&nbsp;&nbsp;	{{ answer.answer_content_en }}
						</li>
					</ul>
					</div>
				</div>			
			</div>
			<div class="buttons-area float-left border-box" ng-controller="actionsBtnCtrl">
				<a class="btn mark-for-review float-left"> Mark for Review</a>
				<a class="btn clear-response float-left">Clear Response</a>
				<a class="btn save-nd-next float-right">Save and Next</a>
			</div>
		</div>
		<div class="right-section float-right border-box">
			<div class="profile" ng-controller="profileCtrl">
				<p>
					<img ng-src="<?= base_url('uploads/')?>{{user.profile_img}}" alt="Profile Image" >
					<span style="padding-top: 15px;"><strong>{{user.name}}</strong></span>
					<span>{{user.username}}</span>
				</p>
			</div>
			<div class="timer float-left" ng-controller="timerCtrl">
				<h3 style="margin-bottom: 0px;" class="section-title">Timer : &nbsp;&nbsp; {{ remaining_time }}&nbsp;Mins</h3>
			</div>
			<div class="question-pallete" ng-controller="questionPalleteCtrl">
				<h4 class="section-title">Question Pallete :</h4>
				<ul class="question-pallete-area">
					<li ng-repeat="(index, question) in questionPallete">
						<a ng-click="selectQuestion(question)" class="question-tile">{{index + 1}}</a>
					</li>
				</ul>
			</div>
			<div class="key-legend" ng-controller="keyLegendCtrl">
			</div>
		</div>
	</div>
	<div class="footer">
	</div>
</div>

<script type="text/javascript" src="<?= base_url('assets/vendor/angular/angular.min.js'); ?>"></script>
<script type="text/javascript" src="<?= base_url('assets/vendor/angular/angular-route.min.js'); ?>"></script>
<script type="text/javascript" src="<?= base_url('/assets/vendor/ckeditor/ckeditor.js'); ?>"></script>
<script type="text/javascript" src="<?= base_url('assets/vendor/angular-ckeditor/angular-ckeditor.min.js'); ?>"></script>
<script type="text/javascript" src="<?= base_url('assets/js/exam.js'); ?>"></script>
<script type="text/javascript" src="<?= base_url('assets/js/exam-controller.js'); ?>"></script>
<script type="text/javascript" src="<?= base_url('assets/js/exam-services.js'); ?>"></script>
</body>
</html>