examApp.controller('subjectsCtrl', ['$scope', 'examService', function($scope, examService) {
    $scope.service = examService;
    $scope.subjects = {};

    $scope.$watch('service.getExamData()', function(newVal, oldVal) {
        $scope.subjects = newVal.subjects;
    });

    $scope.selectSubject = function($subject_ID) {
        $scope.service.selectQuestionsFromSubject($subject_ID);
    };

}]);
examApp.controller('examCtrl', [
    '$scope',
    'examService',
    function($scope, examService) {
        $scope.service = examService;

        $scope.question = {};
        $scope.answers = {};
        $scope.paragraph = {};
        $scope.hasParagraph = false;

        $scope.ckeditorOptions = {
            language: 'en',
            allowedContent: true,
            entities: false
        };

        $scope.onCKEditorReady = function() {
            angular.forEach(CKEDITOR.instances, function(instance) {

                var editor = instance;
                if (editor) {
                    $scope.$apply(function() {
                        editor.on('focus', function(event) {

                            return false;
                        });
                    });
                }
            });
        };

        $scope.$watch('service.getCurrentQuestionData()', function(newVal, oldVal) {
            $scope.question = newVal.question;
            $scope.answers = newVal.answers;

            if (newVal.paragraph) {
                $scope.paragraph = newVal.paragraph;
                $scope.hasParagraph = true;
            } else {
                $scope.paragraph = {};
                $scope.hasParagraph = false;
            }
        }, true);
    }
]);
examApp.controller('actionsBtnCtrl', [function() {

}]);
examApp.controller('profileCtrl', ['$scope', 'examService', function($scope, examService) {
    $scope.user = {};
    $scope.service = examService;
    $scope.$watch('service.getExamData()', function(newVal, oldVal) {
        $scope.user = newVal.user;
    });
}]);
examApp.controller('timerCtrl', ['$scope', function($scope) {
    $scope.remaining_time = "00:00";
}]);
examApp.controller('questionPalleteCtrl', ['$scope', 'examService', function($scope, examService) {
    $scope.questionPallete = {};
    $scope.service = examService;
    $scope.selectQuestion = function(question) {
        examService.setCurrentQuestion(question);
    };
    $scope.$watch('service.getExamData()', function(newVal, oldVal) {
        $scope.questionPallete = newVal.question_pallete;
    }, true);
}]);
examApp.controller('keyLegendCtrl', [function() {

}]);