examApp.factory('examService', ['$http', 'answersFilter', 'paragraphFilter', function($http, answersFilter, paragraphFilter) {
    var url = baseUrl + 'online_exam/get_exam_data';
    var exam_data = {};
    var current_question_data = {
        question: {},
        answers: {},
        paragraph: {}
    };

    var setCurrentQuestionData = function(question) {
        current_question_data.question = question;
        current_question_data.answers = answersFilter(question, exam_data.answers);
        current_question_data.paragraph = paragraphFilter(question, exam_data.paragraphs);
    };

    return {
        getExamDatafromServer: function() {
            return $http.get(url).then(function(response) {
                exam_data = response.data;
                var first_question = exam_data.questions[exam_data.subjects[0].subject_ID][0];
                setCurrentQuestionData(first_question);
            }, function(response) {

            });
        },
        getExamData: function() {
            return exam_data;
        },
        getCurrentQuestionData: function() {
            return current_question_data;
        },
        setCurrentQuestion: function(question_id) {

            var question = {},
                question_found = false;

            for (var i = 0; i < exam_data.subjects.length; i++) {
                var subjects_array = exam_data.questions[exam_data.subjects[i].subject_ID];

                for (var j = 0; j < subjects_array.length; j++) {
                    if (subjects_array[j].question_ID == question_id) {
                        question = subjects_array[j];
                        question_found = true;
                        break;
                    }
                }
                if (question_found) break;
            }
            setCurrentQuestionData(question);
        },
        selectQuestionsFromSubject: function(subject_id) {
            var subject_first_question = exam_data.questions[subject_id][0];
            setCurrentQuestionData(subject_first_question);
        }
    };

}]);