<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Admin extends CI_Controller 
{
    public function admin_session()
    {
       //check session permission for creating the post
        if(!$this->session->userdata('admin_logged_in'))		//check login
        {
            $this->session->set_flashdata('admin_timeout','You are no longer logged in.Login Again.');
            redirect('home/login');
        }

    }

    public function index()
    {
       // echo "this is admin dashboard";
       //$username=$this->session->userdata('username');
       $this->admin_session();

       $title="Dashboard";
       $subtitle="Information At a Glance";
       $data['title']=$title.'<br><small>'.$subtitle.'</small>';
       $data['userdata']=$this->session->userdata;
     
       if(isset($this->session->userdata['admin_id']))
        {
           //$this->load->view('admin/template/admin_index_header',$data);
            //$this->load->view('admin/admin_index',$this->session->userdata);
            //$this->load->view('admin/template/admin_index_footer');
            $data['menus']=$this->menu_permission_model->get_menus(FALSE);
            $data['pages']=$this->menu_permission_model->get_pages(FALSE);
            $data['user_types']=$this->menu_permission_model->get_user_types(FALSE);
            $data['menu_permissions']=$this->menu_permission_model->get_menu_permissions(FALSE);

            $this->load->view('templates/header');
			$this->load->view('templates/nav',$data);
			//$this->load->view('menu_permission',$data);
			$this->load->view('templates/footer');

        } 
        else
        {
            redirect('home/login');
        }

    }

/*add_master_document
manage_master_utype
add_master_branch
add_master_department
add_master_designation


menu_permission_admin
menu_permission_pd
menu_permission_hr
menu_permission_acc
menu_permission_emp


login_access_admin
login_access_pd
login_access_hr
login_access_acc
login_access_emp
*/
public function add_master_document()
{
    $this->admin_session();
    $title="Administration";
    $subtitle="Add New Department";
    $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

    $this->form_validation->set_rules('fname','Employee First Name','required');    
    $this->form_validation->set_rules('lname','Employee Last Name','required');    
    $this->form_validation->set_rules('gender','Employee Gender','required');    
    $this->form_validation->set_rules('status','Employee Status','required');    
    $this->form_validation->set_rules('remarks','Employee Remarks','required');    

    if($this->form_validation->run()===FALSE):
        $this->admin_session();
        $data['employees']=$this->humanresource_model->get_employee();
        $this->load->view('admin/template/admin_index_header',$data);
        $this->load->view('admin/master/add_doc_type',$this->session->userdata);
        $this->load->view('admin/template/admin_index_footer');
    else:
        $employee_updated=$this->humanresource_model->update_employee($this->input->post('emp_id'),$this->input->post('fname'),$this->input->post('lname'),$this->input->post('gender'),$this->input->post('status'),$this->input->post('remarks'));
    endif;  

}
public function manage_master_utype()
{
    $this->admin_session();
    $title="Administration";
    $subtitle="Manage Stakeholders";
    $data['breadcrumb_title']=$title;
    $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

    $data['departments']=$this->humanresource_model->get_departments();
    $data['designations']=$this->humanresource_model->get_designations();
    $data['stakeholder_types']=$this->humanresource_model->get_stakeholder_type_code();
    $data['employees']=$this->humanresource_model->get_employee();

    //echo "<pre>";
    //print_r($data['employees']);
    //echo "</pre>";

    $this->load->view('admin/template/admin_index_header',$data);
    $this->load->view('admin/master/manage_user_type',$data);
    $this->load->view('admin/template/admin_index_footer');

}
public function add_master_branch()
{
    $this->admin_session();
    $title="Administration";
    $subtitle="Add New Branch";
    $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

    $this->form_validation->set_rules('fname','Employee First Name','required');    
    $this->form_validation->set_rules('lname','Employee Last Name','required');    
    $this->form_validation->set_rules('gender','Employee Gender','required');    
    $this->form_validation->set_rules('status','Employee Status','required');    
    $this->form_validation->set_rules('remarks','Employee Remarks','required');    

    if($this->form_validation->run()===FALSE):
        $this->admin_session();
        $data['employees']=$this->humanresource_model->get_employee();
        $this->load->view('admin/template/admin_index_header',$data);
        $this->load->view('admin/master/add_branch',$this->session->userdata);
        $this->load->view('admin/template/admin_index_footer');
    else:
        $employee_updated=$this->humanresource_model->update_employee($this->input->post('emp_id'),$this->input->post('fname'),$this->input->post('lname'),$this->input->post('gender'),$this->input->post('status'),$this->input->post('remarks'));
    endif;  
}
public function add_master_department()
{
    $this->admin_session();
    $title="Administration";
    $subtitle="Add New Department";
    $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

    $this->form_validation->set_rules('fname','Employee First Name','required');    
    $this->form_validation->set_rules('lname','Employee Last Name','required');    
    $this->form_validation->set_rules('gender','Employee Gender','required');    
    $this->form_validation->set_rules('status','Employee Status','required');    
    $this->form_validation->set_rules('remarks','Employee Remarks','required');    

    if($this->form_validation->run()===FALSE):
        $this->admin_session();
        $data['employees']=$this->humanresource_model->get_employee();
        $this->load->view('admin/template/admin_index_header',$data);
        $this->load->view('admin/master/add_department',$this->session->userdata);
        $this->load->view('admin/template/admin_index_footer');
    else:
        $employee_updated=$this->humanresource_model->update_employee($this->input->post('emp_id'),$this->input->post('fname'),$this->input->post('lname'),$this->input->post('gender'),$this->input->post('status'),$this->input->post('remarks'));
    endif;  
    
}
public function add_master_designation()
{
    $this->admin_session();
    $title="Administration";
    $subtitle="Add New Designation";
    $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

    $this->form_validation->set_rules('fname','Employee First Name','required');    
    $this->form_validation->set_rules('lname','Employee Last Name','required');    
    $this->form_validation->set_rules('gender','Employee Gender','required');    
    $this->form_validation->set_rules('status','Employee Status','required');    
    $this->form_validation->set_rules('remarks','Employee Remarks','required');    

    if($this->form_validation->run()===FALSE):
        $this->admin_session();
        $data['employees']=$this->humanresource_model->get_employee();
        $this->load->view('admin/template/admin_index_header',$data);
        $this->load->view('admin/master/add_designation',$this->session->userdata);
        $this->load->view('admin/template/admin_index_footer');
    else:
        $employee_updated=$this->humanresource_model->update_employee($this->input->post('emp_id'),$this->input->post('fname'),$this->input->post('lname'),$this->input->post('gender'),$this->input->post('status'),$this->input->post('remarks'));
    endif;  
    
}


public function menu_permission_admin()
{
    
}
public function menu_permission_pd()
{
    
}
public function menu_permission_hr()
{
    
}
public function menu_permission_acc()
{
    
}
public function menu_permission_emp()
{
    
}



public function login_access_admin()
{
    
}
public function login_access_pd()
{
    
}
public function login_access_hr()
{
    
}
public function login_access_acc()
{
    
}
public function login_access_emp()
{
    
}


}
