<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Home extends CI_Controller 
{

	public function index()
	{
		$this->load->view('home/template/home_index_header');
		$this->load->view('home/home_index');
		$this->load->view('home/template/home_index_footer');
		
    }
    
    public function retrive_password()
	{
        $this->load->view('login/template/login_index_header');
        $this->load->view('login/retrive_password');
        $this->load->view('login/template/login_index_footer');
    }
    
    public function new_register()
	{
        $this->load->view('login/template/login_index_header');
        $this->load->view('login/new_register');
        $this->load->view('login/template/login_index_footer');
    }

	public function login()
    {
              
        $this->form_validation->set_rules('username','Username','required');
        $this->form_validation->set_rules('password','Password','required');

        if($this->form_validation->run()===FALSE)
        {
            $this->load->view('login/template/login_index_header');
            $this->load->view('login/login_index');
            $this->load->view('login/template/login_index_footer');
        }
        else
        {
            $this->login_user($this->input->post('username'),$this->input->post('password'));
        }
        
    }

	private function  login_user($username,$password)
    {             
               //login user , after successful login we will get user_id
               $user_id=$this->users_model->user_login($username,$password);
               $data['user_details']=$this->users_model->get_user_by_user_pass($username,$password); 
               $user_type_code=$this->users_model->get_user_type_code($data['user_details']['user_type']);
               if($data['user_details']['user_type']=='admin'&&$user_type_code=='11'):
                    $admin_data= array(			//passing data of user in array to be available throughout session
                        'admin_id' =>$data['user_details']['emp_id'],
                        'admin_username' =>$data['user_details']['username'],
                        'admin_firstname' =>$data['user_details']['firstname'],
                        'admin_lastname' =>$data['user_details']['lastname'],
                        'admin_email_id' =>$data['user_details']['email_id'],
                        'admin_phone_no' =>$data['user_details']['phone_no'],
                        'admin_profile_pic'=>$data['user_details']['profile_photo'],
                        'admin_logged_in' =>true,
                        'admin_date'=>date("Y-m-d H:i:s"),
                        'admin_usertype'=>$data['user_details']['user_type']
                        );

                        $this->session->set_userdata($admin_data);//setting the user data array to the session
                        //set flash message
                        $this->session->set_flashdata('admin_loggedin','You are now logged in');
                        redirect('admin/index');//redirecting to the posts index page     

                elseif($data['user_details']['user_type']=='hr'&&$user_type_code=='33'):

                    $hr_data= array(			//passing data of user in array to be available throughout session
                        'hr_id' =>$data['user_details']['emp_id'],
                        'hr_username' =>$data['user_details']['username'],
                        'hr_firstname' =>$data['user_details']['firstname'],
                        'hr_lastname' =>$data['user_details']['lastname'],
                        'hr_email_id' =>$data['user_details']['email_id'],
                        'hr_phone_no' =>$data['user_details']['phone_no'],
                        'hr_profile_pic'=>$data['user_details']['profile_photo'],
                        'hr_logged_in' =>true,
                        'hr_date'=>date("Y-m-d H:i:s"),
                        'hr_usertype'=>$data['user_details']['user_type']
                         );
                    
                    $this->session->set_userdata($hr_data);//setting the user data array to the session
                    //set flash message
                    $this->session->set_flashdata('hr_loggedin','You are now logged in');
                    redirect('humanresource/index');//redirecting to the posts index page
 
                elseif($data['user_details']['user_type']=='pd'&&$user_type_code=='22'):
 
                    $pd_data= array(			//passing data of user in array to be available throughout session
                        'pd_id' =>$data['user_details']['emp_id'],
                        'pd_username' =>$data['user_details']['username'],
                        'pd_firstname' =>$data['user_details']['firstname'],
                        'pd_lastname' =>$data['user_details']['lastname'],
                        'pd_email_id' =>$data['user_details']['email_id'],
                        'pd_phone_no' =>$data['user_details']['phone_no'],
                        'pd_profile_pic'=>$data['user_details']['profile_photo'],
                        'pd_logged_in' =>true,
                        'pd_date'=>date("Y-m-d H:i:s"),
                        'pd_usertype'=>$data['user_details']['user_type']
                         );
                    
                    $this->session->set_userdata($pd_data);//setting the user data array to the session
                    //set flash message
                    $this->session->set_flashdata('pd_loggedin','You are now logged in');
                    redirect('projectdirector/index');//redirecting to the posts index page
 
                elseif($data['user_details']['user_type']=='acc'&&$user_type_code=='44'):

                    $acc_data= array(			//passing data of user in array to be available throughout session
                        'acc_id' =>$data['user_details']['emp_id'],
                        'acc_username' =>$data['user_details']['username'],
                        'acc_firstname' =>$data['user_details']['firstname'],
                        'acc_lastname' =>$data['user_details']['lastname'],
                        'acc_email_id' =>$data['user_details']['email_id'],
                        'acc_phone_no' =>$data['user_details']['phone_no'],
                        'acc_profile_pic'=>$data['user_details']['profile_photo'],
                        'acc_logged_in' =>true,
                        'acc_date'=>date("Y-m-d H:i:s"),
                        'acc_usertype'=>$data['user_details']['user_type']
                         );
                    
                    $this->session->set_userdata($acc_data);//setting the user data array to the session
                    //set flash message
                    $this->session->set_flashdata('acc_loggedin','You are now logged in');
                    redirect('accountant/index');//redirecting to the posts index page
 
                elseif($data['user_details']['user_type']=='emp'&&$user_type_code=='55'):

                    $emp_data= array(			//passing data of user in array to be available throughout session
                        'emp_id' =>$data['user_details']['emp_id'],
                        'emp_username' =>$data['user_details']['username'],
                        'emp_firstname' =>$data['user_details']['firstname'],
                        'emp_lastname' =>$data['user_details']['lastname'],
                        'emp_email_id' =>$data['user_details']['email_id'],
                        'emp_phone_no' =>$data['user_details']['phone_no'],
                        'emp_profile_pic'=>$data['user_details']['profile_photo'],
                        'emp_logged_in' =>true,
                        'emp_date'=>date("Y-m-d H:i:s"),
                        'emp_usertype'=>$data['user_details']['user_type']
                         );
                    
                    $this->session->set_userdata($emp_data);//setting the user data array to the session
                    //set flash message
                    $this->session->set_flashdata('emp_loggedin','You are now logged in');
                    redirect('employee/index');//redirecting to the posts index page
 
                else:

                    $this->session->set_flashdata('login_failed','Login is invalid');
                    redirect('home/login');

                endif;
    }





}
