<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class HumanResource extends CI_Controller 
{
    public function humanresource_session()
    {
       //check session permission for creating the post
        if(!$this->session->userdata('hr_logged_in'))		//check login
        {
            $this->session->set_flashdata('hr_timeout','You are no longer logged in.Login Again.');
            redirect('home/login');
        }

    }

    public function index()
    {
       // echo "this is admin dashboard";
       //$username=$this->session->userdata('username');
       $this->humanresource_session();

       $title="Dashboard";
       $subtitle="Information At a Glance";
       $data['title']=$title.'<br><small>'.$subtitle.'</small>';
       $data['userdata']=$this->session->userdata;
     
       if(isset($this->session->userdata['hr_id']))
        {
           // $this->load->view('users/hr/template/hr_index_header',$data);
            //$this->load->view('users/hr/hr_index',$this->session->userdata);
            //$this->load->view('users/hr/template/hr_index_footer');
            $data['menus']=$this->menu_permission_model->get_menus(FALSE);
            $data['pages']=$this->menu_permission_model->get_pages(FALSE);
            $data['user_types']=$this->menu_permission_model->get_user_types(FALSE);
            $data['menu_permissions']=$this->menu_permission_model->get_menu_permissions(FALSE);

            $this->load->view('templates/header');
			$this->load->view('templates/nav',$data);
			//$this->load->view('menu_permission',$data);
			$this->load->view('templates/footer');
 
        } 
        else
        {
            redirect('home/login');
        }

    }

    public function logout()
    {
        $this->humanresource_session();
        $this->session->set_flashdata('hr_loggedout','You are now logged out');

        $this->session->unset_userdata('admin_id');
        $this->session->unset_userdata('admin_username');
        $this->session->unset_userdata('admin_firstname');
        $this->session->unset_userdata('admin_lastname');
        $this->session->unset_userdata('admin_email_id');
        $this->session->unset_userdata('admin_phone_no');
        $this->session->unset_userdata('admin_profile_pic');
        $this->session->unset_userdata('admin_logged_in');
        $this->session->unset_userdata('admin_date');
        $this->session->unset_userdata('admin_usertype');

        redirect('home/login');
        $this->session->sess_destroy();
    }

    public function employee_detail_list()
    {
        $this->humanresource_session();
        $title="Employees";
        $subtitle="All Information";
        $data['breadcrumb_title']=$title;
        $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

        $data['departments']=$this->humanresource_model->get_departments();
        $data['designations']=$this->humanresource_model->get_designations();
        $data['stakeholder_types']=$this->humanresource_model->get_stakeholder_type_code();
        $data['employees']=$this->humanresource_model->get_employee();

        //echo "<pre>";
        //print_r($data['employees']);
        //echo "</pre>";

        $this->load->view('users/hr/template/hr_index_header');
        $this->load->view('users/hr/hr_employees',$data);
        $this->load->view('users/hr/template/hr_index_footer');	     
    }   

    
		//check if email exists	
		public function check_email_exists($email)
		{
			$this->form_validation->set_message('check_email_exists','That Email ID is taken. Please choose a different one');
			
			if($this->humanresource_model->check_email_exists($email))
			{
				return true;
			}
			else
			{
				return false;
			}
		}

		//check if phone number exists	
		public function check_phone_exists($phone)
		{
			$this->form_validation->set_message('check_phone_exists','That Phone Number is taken. Please choose a different one');
			
			if($this->humanresource_model->check_phone_exists($phone))
			{
				return true;
			}
			else
			{
				return false;
			}
		}
		//check if username exists	
		public function check_username_exists($username)
		{
			$this->form_validation->set_message('check_username_exists','That Username is taken. Please choose a different one');
			
			if($this->humanresource_model->check_username_exists($username))
			{
				return true;
			}
			else
			{
				return false;
			}
		}

        public function single_employee_detail()
        {
            $this->humanresource_session();
            $title="Employee";
            $subtitle="Employee ID:".'001';
            $data['breadcrumb_title']=$title;
            $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';
    
            $data['departments']=$this->humanresource_model->get_departments();
            $data['designations']=$this->humanresource_model->get_designations();
            $data['stakeholder_types']=$this->humanresource_model->get_stakeholder_type_code();
            $data['employees']=$this->humanresource_model->get_employee(FALSE);
    
            $this->load->view('users/hr/template/hr_index_header');
            $this->load->view('users/hr/hr_single_employee',$data);
            $this->load->view('users/hr/template/hr_index_footer');	     
        }

    public function add_employee_view()
    {
        $this->humanresource_session();
        $title="Employees";
        $subtitle="Add New Employee";
        $data['breadcrumb_title']=$title;
        $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

        $data['document_types']=$this->humanresource_model->get_document_types();
        $data['departments']=$this->humanresource_model->get_departments();
        $data['designations']=$this->humanresource_model->get_designations();
        $data['stakeholder_types']=$this->humanresource_model->get_stakeholder_type_code();
        $data['employees']=$this->humanresource_model->get_employee(FALSE);


        $this->load->view('users/hr/template/hr_index_header');
        $this->load->view('users/hr/hr_add_employee',$data);
        $this->load->view('users/hr/template/hr_index_footer');	     

    }


    public function add_employee()
    {
        $this->humanresource_session();
        $title="Employees";
        $subtitle="All Information";
        $data['breadcrumb_title']=$title;
        $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

        $data['departments']=$this->humanresource_model->get_departments();
        $data['designations']=$this->humanresource_model->get_designations();
        $data['stakeholder_types']=$this->humanresource_model->get_stakeholder_type_code();
        $data['employees']=$this->humanresource_model->get_employee(FALSE);
    
        $this->form_validation->set_rules('stakeholder_type','Stakeholder Type','required');    
        $this->form_validation->set_rules('department','Employee Department','required');    
        $this->form_validation->set_rules('designation','Employee Designation','required');    
        //$this->form_validation->set_rules('remarks','Remarks(If Any)','required|callback_check_email_exists');    
 
        $this->form_validation->set_rules('username','Employee User Name','required|callback_check_username_exists');
        //to generate('employee_pword','employee_profile_pic','employee_photo_data','employee_created_by',employee_created_at);    
        $this->form_validation->set_rules('fname','Employee First Name','required');    
        $this->form_validation->set_rules('lname','Employee Last Name','required');    
        $this->form_validation->set_rules('gender','Employee Gender','required');    
        $this->form_validation->set_rules('email','Employee Email ID','required|callback_check_email_exists');    
        $this->form_validation->set_rules('phone','Employee Phone No','required|callback_check_phone_exists');    
        $this->form_validation->set_rules('status','Active Status','required');    
        
        $this->form_validation->set_rules('d_o_birth','Date Of birth','required');    
        $this->form_validation->set_rules('marital_status','Marital Status','required');    
        $this->form_validation->set_rules('community','Community','required');    
        $this->form_validation->set_rules('category','Category','required');
        $this->form_validation->set_rules('family_type','Employee family Type','required');    
        $this->form_validation->set_rules('m_toung','Employee Mother Toung','required');    
        $this->form_validation->set_rules('mother_name','Employee Mother Name','required');    
        $this->form_validation->set_rules('father_name','Employee Father Name','required');    
        $this->form_validation->set_rules('guardian_ph','Guardian Phone No','required');    
        $this->form_validation->set_rules('total_sibling','Total Siblings','required');    
        $this->form_validation->set_rules('total_dependents','Total Dependents','required');    
            
        $this->form_validation->set_rules('full_address','full_address','required');    
        $this->form_validation->set_rules('country','Country','required');    
        $this->form_validation->set_rules('state','State','required');    
        $this->form_validation->set_rules('district','District','required');
        $this->form_validation->set_rules('block','Block','required');    
        $this->form_validation->set_rules('pincode','PIN CODE','required');       
         
        $this->form_validation->set_rules('course_degree','Course/Degree','required');    
        $this->form_validation->set_rules('university_board','University/Board','required');    
        $this->form_validation->set_rules('percent_pointer','Percent/Pointer','required');    
        $this->form_validation->set_rules('total_marks','Total Marks','required');
        $this->form_validation->set_rules('y_o_passing','Year Of Passing','required');    
         
        $this->form_validation->set_rules('company_name','Company Name','required');    
        $this->form_validation->set_rules('department_comp','Department','required');    
        $this->form_validation->set_rules('designation_comp','Designation','required');    
        $this->form_validation->set_rules('d_o_joining','Date Of Joining','required');
        $this->form_validation->set_rules('d_o_leaving','Year Of Passing','required');    
                 
        $this->form_validation->set_rules('username','Course/Degree','required');    
        $this->form_validation->set_rules('password','University/Board','required');    
        $this->form_validation->set_rules('pword','Percent/Pointer','required');    

        if($this->form_validation->run()===FALSE):
            $this->humanresource_session();
            $data['employees']=$this->humanresource_model->get_employee(FALSE);
            $this->load->view('users/hr/template/hr_index_header');
            $this->load->view('users/hr/hr_employees',$data);
            $this->load->view('users/hr/template/hr_index_footer');	     
        else:
            $this->load->library('upload');
            //uploading image configuration
            $image_config['upload_path']='./assets/hrms_offical_data/emp_data/profile_photo';
            $image_config['allowed_types']='gif|jpg|png|ico';
            $image_config['max_size']='2048';
            $image_config['max_width']='1024';
            $image_config['max_height']='1024';
            $this->upload->initialize($image_config);
            if ( ! $this->upload->do_upload('emp_profile_pic')):
                // document upload error , display error etc.
                // you might need to delete the former uploaded image file ...
               // $photo_with_dir=site_url().'assets/employee_data/profile_photo/'.$employee_profile_pic;
                //$this->delete_file_from_directory($photo_with_dir);
                $data['emp_photo_error']=array('error'=>$this->upload->display_errors());
                $emp_profile_pic="noimage.jpg";//'nodoc.jpg';
                $data['emp_photo_data']='Not Available';
            else: 
                //$document_data = $this->upload->data();
                $data['emp_photo_data']=$this->upload->data();
                //$post_document=str_replace(" ","_",$_FILES['document']['name']);
                $emp_profile_pic=$data['emp_photo_data']['file_name'];
            endif;
            $emp_photo_data=json_encode($data['emp_photo_data']);
            $emp_pword=random_string('alnum', 16);
            $emp_id=$this->humanresource_model->get_stakeholder_type_code_by_type($this->input->post('stakeholder_type'))."".random_string('numeric', 6);
            $new_emp_registered=$this->humanresource_model->create_new_employee($emp_pword,$emp_profile_pic,$emp_photo_data,$emp_id);
    
            if($new_emp_registered):
              $this->humanresource_session(); 
    
                                //send username and password by email to registered email id of employee
                                $ins_email=$this->input->post('emp_email');
                                $ins_phone=$this->input->post('emp_phone_no');
                                $ins_username=$this->input->post('emp_uname');
                                $ins_password=$this->humanresource_model->retrive_emp_password($ins_email,$ins_phone);
    
                                $config=Array('mailtype'=>'text','protocol'=>'SMTP','smtp_host'=>'mail.gmail.com','smtp_port'=>'465','smtp_user'=>'register@hrms.co.in','smtp_pass'=>'hrms@register','charset'=>'iso-8859-1','newline'=>"\r\n",'smtp_crypto'=>'tls','validation'=>TRUE);
    
                                $this->load->library('email',$config);
                                $this->email->from('register@hrms.co.in', 'iHRMS');//smtp_port=>465,587
                                $this->email->to($ins_email);
                                $this->email->subject('iHRMS Login Credentials.');
                                $this->email->message('Your Username is:  '.$ins_username.'  Your Password is:  '.$ins_password);
    
                                if($this->email->send()):
                                  $this->session->set_flashdata('emp_email_send_success','Employee Registered and Credential sent to Employees Registered Email ID Successfully');
                                else: 
                                  $this->session->set_flashdata('emp_email_send_failed','Employee Registered but Mail sending failed!. Error Sending Employee Credentials. Contact Your Web Master');
                                  show_error($this->email->print_debugger());
                                endif;
              $data['employees']=$this->humanresource_model->get_employee();
              $this->session->set_flashdata('emp_created_success','Employee Registered Successfully');
              $this->load->view('users/hr/template/hr_index_header');
              $this->load->view('users/hr/hr_employees',$data);
              $this->load->view('users/hr/template/hr_index_footer');	     
            else:
              $this->humanresource_session();
              $data['employees']=$this->humanresource_model->get_employee();
              $this->session->set_flashdata('emp_created_failed','Insertion failed!. Error Registering Employee. Contact Your Web Master');
              $this->load->view('users/hr/template/hr_index_header');
              $this->load->view('users/hr/hr_employees',$data);
              $this->load->view('users/hr/template/hr_index_footer');	     
            endif;
        endif;
    }
    
    public function update_employee_view()
    {
        $this->humanresource_session();
        $title="Update Employee";
        $subtitle="Employee ID:";
        $data['breadcrumb_title']=$title;
        $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

        $data['departments']=$this->humanresource_model->get_departments();
        $data['designations']=$this->humanresource_model->get_designations();
        $data['stakeholder_types']=$this->humanresource_model->get_stakeholder_type_code();
        $data['employees']=$this->humanresource_model->get_employee(FALSE);

        $this->load->view('users/hr/template/hr_index_header');
        $this->load->view('users/hr/hr_update_employee',$data);
        $this->load->view('users/hr/template/hr_index_footer');	     
        
    }
public function update_employee()
{
    $this->humanresource_session();
    $title="Employees";
    $subtitle="All Information";
    $data['breadcrumb_title']=$title;
    $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

    $data['departments']=$this->humanresource_model->get_departments();
    $data['designations']=$this->humanresource_model->get_designations();
    $data['stakeholder_types']=$this->humanresource_model->get_stakeholder_type_code();
    $data['employees']=$this->humanresource_model->get_employee(FALSE);

    $this->form_validation->set_rules('fname','Employee First Name','required');    
    $this->form_validation->set_rules('lname','Employee Last Name','required');    
    $this->form_validation->set_rules('gender','Employee Gender','required');    
    $this->form_validation->set_rules('status','Employee Status','required');    
    $this->form_validation->set_rules('remarks','Employee Remarks','required');    

    if($this->form_validation->run()===FALSE):
        $this->humanresource_session();
        $data['employees']=$this->humanresource_model->get_employee();
        $this->load->view('users/hr/template/hr_index_header');
        $this->load->view('users/hr/hr_employees',$data);
        $this->load->view('users/hr/template/hr_index_footer');	     
    else:
        $employee_updated=$this->humanresource_model->update_employee($this->input->post('emp_id'),$this->input->post('fname'),$this->input->post('lname'),$this->input->post('gender'),$this->input->post('status'),$this->input->post('remarks'));

        if($employee_updated):
          $this->humanresource_session();      
          $data['employees']=$this->humanresource_model->get_employee();
          $this->session->set_flashdata('employee_update_success','Employee Updated Successfully');
          $this->load->view('users/hr/template/hr_index_header');
          $this->load->view('users/hr/hr_employees',$data);
          $this->load->view('users/hr/template/hr_index_footer');	     
        else:
          $this->humanresource_session();
          $data['employees']=$this->humanresource_model->get_employee();
          $this->session->set_flashdata('employee_update_failed','Updation failed!. Error Updating Employee. Contact Your Web Master');
          $this->load->view('users/hr/template/hr_index_header');
          $this->load->view('users/hr/hr_employees',$data);
          $this->load->view('users/hr/template/hr_index_footer');	     
        endif;
    endif;
}

public function search_employee()
{
    $this->humanresource_session();
    $title="Employees";
    $subtitle="All Information";
    $data['breadcrumb_title']=$title;
    $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

    $data['departments']=$this->humanresource_model->get_departments();
    $data['designations']=$this->humanresource_model->get_designations();
    $data['stakeholder_types']=$this->humanresource_model->get_stakeholder_type_code();
    $data['employees']=$this->humanresource_model->get_employee(FALSE);

    $this->form_validation->set_rules('search','Search...','required');
  
    if($this->form_validation->run()===FALSE):
        $this->humanresource_session();
        $data['employees']=$this->humanresource_model->get_employee();
        $this->load->view('users/hr/template/hr_index_header');
        $this->load->view('users/hr/hr_employees',$data);
        $this->load->view('users/hr/template/hr_index_footer');	     
    else:
          $this->humanresource_session();  
          $search_item=$this->input->post('search');    
          $data['employees']=$this->humanresource_model->get_employee_search_result($search_item);
          $this->load->view('users/hr/template/hr_index_header');
          $this->load->view('users/hr/hr_employees',$data);
          $this->load->view('users/hr/template/hr_index_footer');	     
    endif;
}

public function activate_employee($employee_id)
{
    $this->humanresource_session();
    $title="Employees";
    $subtitle="All Information";
    $data['breadcrumb_title']=$title;
    $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

    $data['departments']=$this->humanresource_model->get_departments();
    $data['designations']=$this->humanresource_model->get_designations();
    $data['stakeholder_types']=$this->humanresource_model->get_stakeholder_type_code();
    $data['employees']=$this->humanresource_model->get_employee(FALSE);

    $employee_active=$this->humanresource_model->make_active_employee($employee_id);

    if($employee_active):
      $this->humanresource_session();      
      $data['employees']=$this->humanresource_model->get_employee();
      $this->session->set_flashdata('employee_active_success','employee Activated Successfully');
      $this->load->view('users/hr/template/hr_index_header');
      $this->load->view('users/hr/hr_employees',$data);
      $this->load->view('users/hr/template/hr_index_footer');	     
    else:
      $this->humanresource_session();
      $data['employees']=$this->humanresource_model->get_employee();
      $this->session->set_flashdata('employee_active_failed','Activating employee failed!. Error Activating employee. Contact Your Web Master');
      $this->load->view('users/hr/template/hr_index_header');
      $this->load->view('users/hr/hr_employees',$data);
      $this->load->view('users/hr/template/hr_index_footer');	     
    endif;

}
public function deactivate_employee($employee_id)
{
    $this->humanresource_session();
    $title="Employees";
    $subtitle="All Information";
    $data['breadcrumb_title']=$title;
    $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

    $data['departments']=$this->humanresource_model->get_departments();
    $data['designations']=$this->humanresource_model->get_designations();
    $data['stakeholder_types']=$this->humanresource_model->get_stakeholder_type_code();
    $data['employees']=$this->humanresource_model->get_employee(FALSE);

    $employee_inactive=$this->humanresource_model->make_inactive_employee($employee_id);

    if($employee_inactive):
      $this->humanresource_session();      
      $data['employees']=$this->humanresource_model->get_employee();
      $this->session->set_flashdata('employee_inactive_success','employee Deactivated Successfully');
      $this->load->view('users/hr/template/hr_index_header');
      $this->load->view('users/hr/hr_employees',$data);
      $this->load->view('users/hr/template/hr_index_footer');	     
    else:
      $this->humanresource_session();
      $data['employees']=$this->humanresource_model->get_employee();
      $this->session->set_flashdata('employee_inactive_failed','Deactivating employee failed!. Error Dectivating employee. Contact Your Web Master');
      $this->load->view('users/hr/template/hr_index_header');
      $this->load->view('users/hr/hr_employees',$data);
      $this->load->view('users/hr/template/hr_index_footer');	     
    endif;
}


    public function terminate_employee()
    {
        $this->humanresource_session();

        $employee_id=$this->input->post('emp_id');
        $termination_remarks=$this->input->post('remarks');

        $title="Employees";
        $subtitle="All Information";
        $data['breadcrumb_title']=$title;
        $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

        //$data['departments']=$this->humanresource_model->get_departments();
        //$data['designations']=$this->humanresource_model->get_designations();
        //$data['stakeholder_types']=$this->humanresource_model->get_stakeholder_type_code();
        $data['employees']=$this->humanresource_model->get_employee(FALSE);
    
        $employee_terminated=$this->humanresource_model->terminate_employee($employee_id,$termination_remarks);

        if($employee_terminated):
          $this->humanresource_session();      
          $data['employees']=$this->humanresource_model->get_employee();
          $this->session->set_flashdata('employee_terminated_success','employee Terminated Successfully');
          $this->load->view('users/hr/template/hr_index_header');
          $this->load->view('users/hr/hr_employees',$data);
          $this->load->view('users/hr/template/hr_index_footer');	     
        else:
          $this->humanresource_session();
          $data['employees']=$this->humanresource_model->get_employee();
          $this->session->set_flashdata('employee_terminated_failed','Terminate employee failed!. Error Terminating employee. Contact Your Web Master');
          $this->load->view('users/hr/template/hr_index_header');
          $this->load->view('users/hr/hr_employees',$data);
          $this->load->view('users/hr/template/hr_index_footer');	     
        endif;
                
    }

    public function terminated_employee_list()
    {
        $this->humanresource_session();
        $title="Terminated Employees";
        $subtitle="All Information";
        $data['breadcrumb_title']=$title;
        $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

        //$data['departments']=$this->humanresource_model->get_departments();
        //$data['designations']=$this->humanresource_model->get_designations();
        //$data['stakeholder_types']=$this->humanresource_model->get_stakeholder_type_code();
        $data['employees']=$this->humanresource_model->get_terminated_employee();

        //echo "<pre>";
        //print_r($data['employees']);
        //echo "</pre>";

        $this->load->view('users/hr/template/hr_index_header');
        $this->load->view('users/hr/hr_terminated_employees',$data);
        $this->load->view('users/hr/template/hr_index_footer');	     
    }   

    
    public function terminated_single_employee_detail()
    {
        $this->humanresource_session();
        $title="Terminated Employee";
        $subtitle="Employee ID/Terminate ID:".'001/1010';
        $data['breadcrumb_title']=$title;
        $data['title']=$title.'<br><span style="font-color:red;font-size:15px;">&#x263A;'.$subtitle.'&#x263A;</span>';

        //$data['departments']=$this->humanresource_model->get_departments();
        //$data['designations']=$this->humanresource_model->get_designations();
        //$data['stakeholder_types']=$this->humanresource_model->get_stakeholder_type_code();
        $data['employees']=$this->humanresource_model->get_employee(FALSE);

        $this->load->view('users/hr/template/hr_index_header');
        $this->load->view('users/hr/hr_single_terminated_employee',$data);
        $this->load->view('users/hr/template/hr_index_footer');	     
    }

    public function manage_emp_deg_dept()
    {
        
    }

    public function manage_emp_sal_setup()
    {
        
    }

    public function manage_emp_leave_att()
    {
        
    }

    public function manage_emp_appraisal()
    {
        
    }

    public function work_order()
    {

    }

    public function work_order_bill()
    {

    }

    public function my_profile_view()
    {
        
    }

    public function my_profile_update()
    {
        
    }

    public function information_board()
    {

    }


    

}

