<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Exam_Standard extends CI_Controller{
    
    public function __construct() {
        parent::__construct();
        $this->data['page_name'] = "Exam Standard";
        $this->load->model('exam_standard_model','es_model');
    }
    
    public function index(){        
        $this->data['exam_standards'] = $this->es_model->get();
        $this->load->view('exam_standard/index',$this->data);
    }
    
    public function create(){
        $this->form_validation->set_rules(array(
            array(
                'field' => 'exam_standard',
                'label' => 'Exam Standard',
                'rules' => 'required',
                'errors' => array(
                        'required' => '%s cannot be left blank.',
                ),
            ),
        ));
        if($this->form_validation->run() === true){
            if($this->es_model->insert()){
                set_alert('success' ,'New Exam Standard Created Successfully.' );
                redirect('exam_standard','refresh');
            } else {
                set_alert('error' , 'Error While Creating Exam Standard.');
            }
        }
        $this->load->view('exam_standard/create',$this->data);
    }
    
    public function edit(){
        $this->data['exam_standards'] = $this->es_model->get($this->input->post('edit_id'));
        $this->load->view('exam_standard/edit',$this->data);
    }
    
    public function update(){
        
            if($this->es_model->update()){
                set_alert('success' ,'Exam Standard Updated Successfully.' );
                redirect('exam_standard','refresh');
            } else {
                set_alert('error' , 'Error While Updating Exam Standard.');
            }
        
    }
    
    public function delete(){
        if( $this->es_model->delete($this->input->post('delete_id')) ){
            set_alert('success','Exam Standard deleted successfully.');
        } else {
            set_alert('error','Error while deleting Exam Standard.');
        }
        redirect('exam_standard');
    }
}

