<?php defined('BASEPATH') OR exit('No direct script access allowed');
/**
* Role Permissions
*/
class Role_Permissions extends CI_Controller
{	

	public function __construct()
	{
		parent::__construct();

       $this->data['page_name'] = "Role Permissions";
        
       $this->load->model('role_permissions_model');
       $this->data['parent_pages'] = $this->role_permissions_model->getParentPages();
	}

	public function index() 
	{
		$this->data['role_permissions'] = $this->role_permissions_model->get();
		$this->load->view('role_permissions/index',$this->data);
	}

	public function create()
	{
		
		$this->form_validation->set_rules(array(
            array(
                'field' => 'page_title',
                'label' => 'Page Title',
                'rules' => 'required',
                'errors' => array(
                        'required' => 'You must provide a %s.',
                ),
            ),
            array(
                'field' => 'page_label',
                'label' => 'Page Label',
                'rules' => 'required',
                'errors' => array(
                        'required' => 'You must provide a %s.',
                ),
			),
			array(
                'field' => 'page_url',
                'label' => 'Page URL',
                'rules' => 'required',
                'errors' => array(
                        'required' => 'You must provide a %s.',
                ),
			)
        ));
        if( $this->form_validation->run() ){
        	if($this->role_permissions_model->insert()){
        		set_alert('success','New Role Permission Created Successfully.' );
        		redirect('role_permissions');
        	} else {
        		set_alert('error','Error while creating Role Permission.' );
        	}
        }
		$this->load->view('role_permissions/create',$this->data);
	}

	public function edit(){
		$this->data['page'] = $this->role_permissions_model->get($this->input->post('edit_id'));
		$this->load->view('role_permissions/edit',$this->data);
	}

	public function update(){
		$this->form_validation->set_rules(array(
            array(
                'field' => 'page_title',
                'label' => 'Page Title',
                'rules' => 'required',
                'errors' => array(
                        'required' => 'You must provide a %s.',
                ),
            ),
            array(
                'field' => 'page_label',
                'label' => 'Page Label',
                'rules' => 'required',
                'errors' => array(
                        'required' => 'You must provide a %s.',
                ),
			),
			array(
                'field' => 'page_url',
                'label' => 'Page URL',
                'rules' => 'required',
                'errors' => array(
                        'required' => 'You must provide a %s.',
                ),
			)
        ));
        if( $this->form_validation->run() ){
        	if($this->role_permissions_model->update()){
        		set_alert('success','Role Permission updated Successfully.' );
        		redirect('role_permissions');
        	} else {
        		set_alert('error','Error while updating Role Permission.' );
        	}
        }
	}

	public function delete(){
		if( $this->role_permissions_model->delete($this->input->post('delete_id')) ){
			set_alert('success','Role Permission deleted successfully.');
		} else {
			set_alert('error','Error while deleting Role Permission.');
		}
		redirect('role_permissions');
	}
}