<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* Settings
*/
class Settings extends CI_Controller
{
	
	public function __construct()
	{
		parent::__construct();

		$this->data['page_name'] = "Settings";
		 /**
         * Loading Models
         */
        $this->load->model('setting_model');
	}

	public function index()
	{
    	$this->data['settings'] = $this->setting_model->get();
	   $this->load->view('settings/index',$this->data);
	}

    public function create()
    {
        $this->form_validation->set_rules(array(
            array(
                'field' => 'settings_name',
                'label' => 'Settings Name',
                'rules' => 'required|is_unique[settings.settings_name]',
                'errors' => array(
                        'required' => '%s cannot be blank.',
                        'is_unique' => '%s cannot be duplicat.'
                ),
            ),
			array(
                'field' => 'settings_value',
                'label' => 'Settings Value',
                'rules' => 'required',
                'errors' => array(
                        'required' => '%s cannot be blank.',
                ),
            ),
        ));
        if($this->form_validation->run() === true){
            if($this->setting_model->insert()){
                set_alert('success' ,'New Settings Created Successfully.' );
                redirect('settings','refresh');
            } else {
                set_alert('error' , 'Error While Creating Settings.');
            }
        }
        $this->load->view('settings/create',$this->data);
    }

    public function edit(){
        $this->data['settings'] = $this->setting_model->get($this->input->post('edit_id'));
        $this->load->view('settings/edit',$this->data);
    }

    public function update(){
            if($this->setting_model->update()){
                set_alert('success' ,'Settings updated Successfully.' );
                redirect('settings');
            } else {
                set_alert('error' , 'Error While editing Settings.');
            }
    }

    public function delete(){
        if( $this->setting_model->delete($this->input->post('delete_id')) ){
            set_alert('success','Settings  deleted successfully.');
        } else {
            set_alert('error','Error while deleting Settings .');
        }
        redirect('settings');
    }
}