<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Subjects extends CI_Controller {

 public function __construct (){
        parent::__construct();

        $this->data['page_name'] = "Subjects";

        /**
         * Loading Models
         */
        $this->load->model('subject_model');
    }

    public function index()
	{
        $this->data['subjects'] = $this->subject_model->get();
	   $this->load->view('subjects/index',$this->data);
	}

    public function create()
    {
        $this->form_validation->set_rules(array(
            array(
                'field' => 'subjects',
                'label' => 'Subjects',
                'rules' => 'required',
                'errors' => array(
                        'required' => '%s cannot be left blank.',
                ),
            ),
        ));
        if($this->form_validation->run() === true){
            if($this->subject_model->insert()){
                set_alert('success' ,'New Subject Created Successfully.' );
                redirect('subjects','refresh');
            } else {
                set_alert('error' , 'Error While Creating Subject.');
            }
        }
        $this->load->view('subjects/create',$this->data);
    }

    public function edit(){
        $this->data['subjects'] = $this->subject_model->get($this->input->post('edit_id'));
        $this->load->view('subjects/edit',$this->data);
    }

    public function update(){
            if($this->subject_model->update()){
                set_alert('success' ,'Subject updated Successfully.' );
                redirect('subjects');
            } else {
                set_alert('error' , 'Error While editing User Role.');
            }
    }

    public function delete(){
        if( $this->subject_model->delete($this->input->post('delete_id')) ){
            set_alert('success','Subject deleted successfully.');
        } else {
            set_alert('error','Error while deleting Subject.');
        }
        redirect('subjects');
    }


}