<?php defined('BASEPATH') || exit('No direct script access allowed');

/**
* Subscription Pack
*/
class Subscription_Packs extends CI_Controller
{
	
	function __construct()
	{
		parent::__construct();

		$this->data['page_name'] = "Subscription Packs";

        $this->load->model('subscription_pack_model');
		$this->load->model('exam_standard_model');

        $this->data['exam_standards']=$this->exam_standard_model->get();
	}

	public function index()
	{
		$this->data['subscriptions_packs'] = $this->subscription_pack_model->get();
		$this->load->view('subscription_packs/index',$this->data);
	}

	public function create()
	{
		$this->form_validation->set_rules(array(
            array(
                'field' => 'subscription_pack_name',
                'label' => 'Subscription Pack Name',
                'rules' => 'required',
                'errors' => array(
                        'required' => '%s cannot be left blank.',
                ),
            ),
			array(
                'field' => 'subscription_amount',
                'label' => 'Subscription Amount',
                'rules' => 'required|numeric',
                'errors' => array(
                        'required' => '%s cannot be left blank.',
                        'numeric' => '%s only accept number'
                ),
            ),
            array(
                'field' => 'exam_standards[]',
                'label' => 'Exam Standards',
                'rules' => 'required',
                'errors' => array(
                        'required' => 'You must select atleast one %s.'
                ),
            ),
			array(
                'field'     => 'duration',
                'label'     => 'Duration',
                'rules'     => 'required|numeric|in_list[30,90,180,360]',
                'errors'    => array(
                        'required' => 'You must provide a %s period.',
                        'numeric' => '%s must be in numbers.',
                        'in_list' => '%s must be of 30, 90, 180 or 360 days.'
                ),
            ),
            array(
                'field'     => 'total_questions',
                'label'     => 'Total No. of Questions',
                'rules'     => 'required|numeric',
                'errors'    => array(
                        'required' => 'Please enter %s to provide in this pack.',
                        'numeric' => '%s must be numeric value.'
                ),
            ),
            array(
                'field'     => 'no_of_exams',
                'label'     => 'No.of Exams',
                'rules'     => 'required|numeric',
                'errors'    => array(
                        'required' => 'Please enter %s to provide in this pack.',
                        'numeric' => '%s must be numeric value.'
                ),
            ),
        ));
        if($this->form_validation->run() === true){
            if($this->subscription_pack_model->insert()){
                set_alert('success' ,'New Subscription Pack Created Successfully.' );
                redirect('subscription_packs','refresh');
            } else {
                set_alert('error' , 'Error While Creating Subscription Pack.');
            }
        }
		$this->load->view('subscription_packs/create',$this->data);
	}

	public function edit()
	{
		$this->data['subscription_pack'] = $this->subscription_pack_model->get($this->input->post('edit_id'));
		$this->load->view('subscription_packs/edit',$this->data);
	}

	public function update()
	{
            if($this->subscription_pack_model->update()){
                set_alert('success' ,'Subscription Pack updated Successfully.' );
                redirect('subscription_packs');
            } else {
                set_alert('error' , 'Error While editing Subscription Pack.');
            }

	}

	public function delete()
	{
		if( $this->subscription_pack_model->delete($this->input->post('delete_id')) ){
            set_alert('success','Subscription Pack deleted successfully.');
        } else {
            set_alert('error','Error while deleting Subscription Pack.');
        }
        redirect('subscription_packs');

	}
}