<?php defined('BASEPATH') || exit('No direct script access allowed.');

/**
* Subscription_renewal
*/
class Subscription_Renewal extends CI_Controller
{
	
	function __construct()
	{
		parent::__construct();
		$this->data['page_name'] = "Subscription Renewal";

		/**
		 * Loading Models
		 */
		$this->load->model('student_model');
        $this->load->model('subscription_pack_model');
        $this->load->model('subscription_model');

        $this->data['students'] = $this->student_model->get();
		$this->data['subscription_packs'] = $this->subscription_pack_model->get();
	}

	public function index()
	{
		$this->data['subscriptions'] = $this->_getExpiredSubscriptions($this->subscription_model->get());
		$this->load->view('subscription_renewal/index',$this->data);
	}

	public function renew()
	{
		if($this->input->post('subscription_id') == NULL) {
			set_alert('warning','You have not selected any subscription to be Renewed.');
			redirect('subscription_renewal');
		}

		if(isset($_POST['renew'])) {
			$this->form_validation->set_rules(array(
				array(
					'field' => 'subscription_pack',
	                'label' => 'Subscription Pack',
	                'rules' => 'required',
	                'errors' => array(
	                        'required' => 'Please select a %s.',
	                ),
				)
			));
		}

		if($this->form_validation->run()==TRUE){
			if($this->subscription_model->renew($this->input->post('subscription_id'))) {
				set_alert('success','Subscription Renewed Successfully.');
				redirect('subscription');
			} else {
				set_alert('error','Error while renewing Subscription.');
			}
		}


		$this->data['subscription'] = $this->subscription_model->get($this->input->post('subscription_id'));
		$this->data['student'] = $this->student_model->get($this->data['subscription']->user_ID);

		$this->load->view('subscription_renewal/renew',$this->data);
	}

	protected function _getExpiredsubscriptions($all_subscriptions)
	{
		$subscription_data = array();
		

		foreach($this->data['students'] as $key=>$student) {
			$subscription_data[$key] = array();
			foreach($all_subscriptions as $subscription) {
				if($subscription['parent']->user_ID == $student->user_ID):
					$expired = false;
					$expired_subscription = '';

					foreach($this->data['subscription_packs'] as $pack) {
						if($subscription['parent']->subscription_pack_ID == $pack->subscription_pack_ID) {
							$duration = $pack->duration-1;
                        	$valid_upto = strtotime("$duration days", strtotime($subscription['parent']->valid_from));
                        	$today = strtotime(date("Y-m-d",time()));
							if( $today > $valid_upto ) {
								$expired = true;
								$expired_subscription = $subscription['parent'];
							}
						}
					}

					foreach ($subscription['renewals'] as $renewal){
						foreach($this->data['subscription_packs'] as $pack) {
							if($renewal->subscription_pack_ID == $pack->subscription_pack_ID) {
								$duration = $pack->duration-1;
	                        	$valid_upto = strtotime("$duration days", strtotime($renewal->valid_from));
	                        	$today = strtotime(date("Y-m-d",time()));
	                        	if( $valid_upto > $today ) {
	                        		$expired = false;
	                        		$expired_subscription = '';
	                        	}
								if( $today > $valid_upto ) {
									$expired = true;
									$expired_subscription = $subscription['parent'];
								}
							}
						}

					}

					if($expired) {
						array_push($subscription_data[$key], $expired_subscription);
					}
				endif;
			}
		}
		return $subscription_data;
	}
}