<?php defined('BASEPATH') OR exit('No direct script access allowed');

class User_Role extends CI_Controller {
    public $data = array();

    public function __construct (){
        parent::__construct();
        
        $this->data['page_name'] = "User Role";

        /**
         * Loading Models
         */
        $this->load->model('user_role_model');
        $this->load->model('role_permissions_model');
    }

	
	public function index()
	{
        $this->data['user_roles'] = $this->user_role_model->get();
	   $this->load->view('user_role/index',$this->data);
	}

    public function create()
    {
        $this->form_validation->set_rules(array(
            array(
                'field' => 'user_role',
                'label' => 'User Role',
                'rules' => 'required|alpha_numeric',
                'errors' => array(
                        'required' => '%s cannot be left blank.',
                        'alpha_numeric' => '%s cannot accept special Character. you may use alpha numeric',
                ),
            )
        ));
        if($this->form_validation->run() === true){
            if($this->user_role_model->insert()){
                set_alert('success' ,'New User Role Created Successfully.' );
                redirect('user_role','refresh');
            } else {
                set_alert('error' , 'Error While Creating User Role.');
            }
        }
        $this->load->view('user_role/create',$this->data);
    }

    public function edit(){
        $this->data['user_role'] = $this->user_role_model->get($this->input->post('edit_id'));
        $this->load->view('user_role/edit',$this->data);
    }

    public function update(){
        $this->form_validation->set_rules(array(
            array(
                'field' => 'user_role',
                'label' => 'User Role',
                'rules' => 'required',
                'errors' => array(
                        'required' => 'You must provide a name for %s.',
                ),
            ),
        ));
        if($this->form_validation->run() === true){
            if($this->user_role_model->update()){
                set_alert('success' ,'User Role updated Successfully.' );
                redirect('user_role');
            } else {
                set_alert('error' , 'Error While editing User Role.');
            }
        }
    }

    public function delete(){
        if( $this->user_role_model->delete($this->input->post('delete_id')) ){
            set_alert('success','User Role deleted successfully.');
        } else {
            set_alert('error','Error while deleting User Role.');
        }
        redirect('user_role');
    }

    public function manage_permissions(){
        $this->data['role_permissions'] = $this->role_permissions_model->get();
        $this->data['user_roles'] = $this->user_role_model->get();

        if( $this->role_permissions_model->update_permissions() ){
            set_alert('success','Permissions to Users updated successfully.');
        }

        $this->load->view('user_role\manage_permissions',$this->data);
    }
}
