<?php defined('BASEPATH') OR exit('No direct script access allowed');

if ( ! function_exists('form_input'))
{
	/**
	 * Text Input Field
	 *
	 * @param	name : Name attribute of the field
	 * @param	label : Label text for the field
	 * @param	value : Default value for the value field
	 * @param	class['form-group'] : Classes for input
	 * @param	class['form-group'] : Classes for form group
	 * @param	form-control-size : Size of input control
	 */
	function form_input($attr)
	{
		$attr['value'] = (isset($attr['value']))? $attr['value']:set_value($attr['name']);
		$attr['form-control-size'] = (isset($attr['form-control-size']))? $attr['form-control-size']:'input-sm';
		$attr['class']['form-group'] = (isset($attr['class']['form-group']))? $attr['class']['form-group']:'';
		$attr['class']['form-control'] = (isset($attr['class']['form-control']))? $attr['class']['form-control']:'';

		$html = '<div class="form-group '.$attr['class']['form-group'].'">';
		$html .= 	'<label for="'.$attr['name'].'">'.$attr['label'].'</label>';
		$html .= 	'<input type="text" class="form-control '.$attr['form-control-size'].' '.$attr['class']['form-control'].' " id="'.$attr['name'].
		'" name="'.$attr['name'].'" value="'.$attr['value'].'">';
		$html .= 	'<span class="error">'.form_error($attr['name']) .'</span>';
        $html .= '</div>';

		return $html;
	}
}

if ( ! function_exists('form_input_horizontal'))
{
	/**
	 * Text Input Field
	 *
	 * @param	name : Name attribute of the field
	 * @param	label : Label text for the field
	 * @param	value : Default value for the value field
	 * @param	class['form-group'] : Classes for input
	 * @param	class['form-group'] : Classes for form group
	 * @param	form-control-size : Size of input control
	 */
	function form_input_horizontal($attr)
	{
		$attr['value'] = (isset($attr['value']))? $attr['value']:set_value($attr['name']);
		$attr['form-control-size'] = (isset($attr['form-control-size']))? $attr['form-control-size']:'input-sm';
		$attr['class']['form-group'] = (isset($attr['class']['form-group']))? $attr['class']['form-group']:'';
		$attr['class']['control-label'] = (isset($attr['class']['control-label']))? $attr['class']['control-label']:'col-sm-3';
		$attr['class']['form-control'] = (isset($attr['class']['form-control']))? $attr['class']['form-control']:'col-sm-8';

		$html = '<div class="form-group '.$attr['class']['form-group'].'">';
		$html .= 	'<label class="control-label '.$attr['class']['control-label'].'" for="'.$attr['name'].'">'.$attr['label'].'</label>'.
					'<div class="'.$attr['class']['form-control'].'">';
		$html .= 	'<input type="text" class="form-control '.$attr['form-control-size'].'" id="'.$attr['name'].
					'" name="'.$attr['name'].'" value="'.$attr['value'].'">';
		$html .= 	'<span class="error">'.form_error($attr['name']) .'</span>'.
					'</div>';
        $html .= '</div>';

		return $html;
	}
}

if ( ! function_exists('form_textarea'))
{
	/**
	 * Text Input Field
	 *
	 * @param	name : Name attribute of the field
	 * @param	label : Label text for the field
	 * @param	value : Default value for the value field
	 * @param	class['form-group'] : Classes for input
	 * @param	class['form-group'] : Classes for form group
	 * @param	form-control-size : Size of input control
	 */
	function form_textarea($attr)
	{
		$attr['value'] = (isset($attr['value']))? $attr['value']:set_value($attr['name']);
		$attr['form-control-size'] = (isset($attr['form-control-size']))? $attr['form-control-size']:'input-sm';
		$attr['rows'] = (isset($attr['rows']))? $attr['rows']:'5';
		$attr['class']['form-group'] = (isset($attr['class']['form-group']))? $attr['class']['form-group']:'';
		$attr['class']['form-control'] = (isset($attr['class']['form-control']))? $attr['class']['form-control']:'col-sm-8';
		

		$html = '<div class="form-group '.$attr['class']['form-group'].'">';
		$html .= 	'<label for="'.$attr['name'].'">'.$attr['label'].'</label>'.
					'<div class="'.$attr['class']['form-control'].'">';
		$html .= 	'<textarea rows="'.$attr['rows'].'" class="form-control '.$attr['form-control-size'].' '.$attr['class']['form-control'].'" id="'.$attr['name'].
					'" name="'.$attr['name'].'" >'.$attr['value'].'</textarea>';
		$html .= 	'<span class="error">'.form_error($attr['name']) .'</span>';
        $html .= '</div>';

		return $html;
	}
}


if ( ! function_exists('form_textarea_horizontal'))
{
	/**
	 * Text Input Field
	 *
	 * @param	name : Name attribute of the field
	 * @param	label : Label text for the field
	 * @param	value : Default value for the value field
	 * @param	class['form-group'] : Classes for input
	 * @param	class['form-group'] : Classes for form group
	 * @param	form-control-size : Size of input control
	 */
	function form_textarea_horizontal($attr)
	{
		$attr['value'] = (isset($attr['value']))? $attr['value']:set_value($attr['name']);
		$attr['form-control-size'] = (isset($attr['form-control-size']))? $attr['form-control-size']:'input-sm';
		$attr['rows'] = (isset($attr['rows']))? $attr['rows']:'5';
		$attr['class']['form-group'] = (isset($attr['class']['form-group']))? $attr['class']['form-group']:'';
		$attr['class']['control-label'] = (isset($attr['class']['control-label']))? $attr['class']['control-label']:'col-sm-3';
		$attr['class']['form-control'] = (isset($attr['class']['form-control']))? $attr['class']['form-control']:'col-sm-8';
		

		$html = '<div class="form-group '.$attr['class']['form-group'].'">';
		$html .= 	'<label class="control-label '.$attr['class']['control-label'].'" for="'.$attr['name'].'">'.$attr['label'].'</label>'.
					'<div class="'.$attr['class']['form-control'].'">';
		$html .= 	'<textarea rows="'.$attr['rows'].'" class="form-control '.$attr['form-control-size'].'" id="'.$attr['name'].
					'" name="'.$attr['name'].'" >'.$attr['value'].'</textarea>';
		$html .= 	'<span class="error">'.form_error($attr['name']) .'</span>'.
					'</div>';
        $html .= '</div>';

		return $html;
	}
}





if ( ! function_exists('hidden_input'))
{
	/**
	 * Text Input Field
	 *
	 * @param	name : Name attribute of the field
	 * @param	label : Label text for the field
	 */
	function hidden_input($attr)
	{
		$attr['value'] = (isset($attr['value']))? $attr['value']:set_value($attr['name']);
		$html = '<input type="hidden" id="'.$attr['name'].'" name="'.$attr['name'].'" value="'.$attr['value'].'">';
		return $html;
	}
}


if ( ! function_exists('form_dropdown'))
{
	/**
	 * Drop-down Menu
	 *
	 * @param	mixed	$data
	 * @param	mixed	$options
	 * @param	mixed	$selected
	 * @param	mixed	$extra
	 * @return	string
	 */
	function form_dropdown($attr)
	{
		$attr['form-control-size'] = (isset($attr['form-control-size']))? $attr['form-control-size']:'input-sm';
		$attr['class']['form-group'] = (isset($attr['class']['form-group']))? $attr['class']['form-group']:'';
		$attr['class']['form-control'] = (isset($attr['class']['form-control']))? $attr['class']['form-control']:'';
		$attr['placeholder'] = (isset($attr['placeholder']))? $attr['placeholder']:'Select an option';
		$attr['disabled'] = (isset($attr['disabled']) && $attr['disabled'])? 'disabled="disabled"':'';

		$html = '<div class="form-group '.$attr['class']['form-group'].'">';
		$html .= '<label for="'.$attr['name'].'">'.$attr['label'].'</label>';
		$html .= '<select class="form-control '.$attr['form-control-size'].' '.$attr['class']['form-control'].'" id="'.$attr['name'].'" name="'.$attr['name'].'" '.$attr['disabled'].' >';
		$html .= '<option value="">'.$attr['placeholder'].'</option>';
		foreach($attr['options'] as $key=>$value){
			$html .= '<option value="'.$key.'" '.set_select($attr['name'], $key,(isset($attr['selected'])&&$attr['selected']==$key)?TRUE:FALSE).'>'.$value.'</option>';
		}
		$html .= '</select>';
		$html .= '<span class="error">'.form_error($attr['name']) .'</span>';
		$html .= '</div>';
        return $html;		
	}
}

if ( ! function_exists('form_dropdown_horizontal'))
{
	/**
	 * Drop-down Menu
	 *
	 * @param	mixed	$data
	 * @param	mixed	$options
	 * @param	mixed	$selected
	 * @param	mixed	$extra
	 * @return	string
	 */
	function form_dropdown_horizontal($attr)
	{
		$attr['form-control-size'] = (isset($attr['form-control-size']))? $attr['form-control-size']:'input-sm';
		$attr['class']['form-group'] = (isset($attr['class']['form-group']))? $attr['class']['form-group']:'';
		$attr['class']['form-control'] = (isset($attr['class']['form-control']))? $attr['class']['form-control']:'col-sm-8';
		$attr['class']['control-label'] = (isset($attr['class']['control-label']))? $attr['class']['control-label']:'col-sm-3';
		$attr['placeholder'] = (isset($attr['placeholder']))? $attr['placeholder']:'Select an option';

		$html = '<div class="form-group '.$attr['class']['form-group'].'">';
		$html .= '<label class="control-label '.$attr['class']['control-label'].'" for="'.$attr['name'].'">'.$attr['label'].'</label>';
		$html .= '<div class="'.$attr['class']['form-control'].'" >';
		$html .= '<select class="form-control '.$attr['form-control-size'].'" id="'.$attr['name'].'" name="'.$attr['name'].'">';
		$html .= '<option value="">'.$attr['placeholder'].'</option>';
		foreach($attr['options'] as $key=>$value){
			$html .= '<option value="'.$key.'" '.set_select($attr['name'], $key,(isset($attr['selected'])&&$attr['selected']==$key)?TRUE:FALSE).'>'.$value.'</option>';
		}
		$html .= '</select>';
		$html .= '<span class="error">'.form_error($attr['name']) .'</span>';
		$html .= '</div>';
		$html .= '</div>';
        return $html;		
	}
}


if ( ! function_exists('form_multiselect'))
{
	/**
	 * Drop-down Menu
	 *
	 * @param	mixed	$data
	 * @param	mixed	$options
	 * @param	mixed	$selected
	 * @param	mixed	$extra
	 * @return	string
	 */
	function form_multiselect($attr)
	{
		$attr['form-control-size'] = (isset($attr['form-control-size']))? $attr['form-control-size']:'input-sm';
		$attr['class']['form-group'] = (isset($attr['class']['form-group']))? $attr['class']['form-group']:'';
		$attr['class']['form-control'] = (isset($attr['class']['form-control']))? $attr['class']['form-control']:'';

		$html = '<div class="form-group '.$attr['class']['form-group'].'">';
		$html .= '<label for="'.$attr['name'].'">'.$attr['label'].'</label>';
		$html .= '<select multiple="multiple" class="form-control '.$attr['form-control-size'].' '.$attr['class']['form-control'].'" id="'.$attr['name'].'" name="'.$attr['name'].'">';
		foreach($attr['options'] as $key=>$value){
			$html .= '<option value="'.$key.'" '.set_select($attr['name'], $key,(isset($attr['selected']) && in_array($key,$attr['selected']))?TRUE:FALSE).'>'.$value.'</option>';
		}
		$html .= '</select>';
		$html .= '<span class="error">'.form_error($attr['name']) .'</span>';
		$html .= '</div>';
        return $html;
	}
}


if ( ! function_exists('form_checkbox'))
{
	/**
	 * Text Input Field
	 *
	 * @param	name : Name attribute of the field
	 * @param	label : Label text for the field
	 */
	function form_checkbox($attr)
	{
		$ci = get_instance();
		$attr['class']['form-group'] = (isset($attr['class']['form-group']))? $attr['class']['form-group']:'';

		if ( $ci->input->post($attr['name']) !== null ) {
			$checked = ($attr['value'] == $ci->input->post($attr['name']))?'checked="checked"':'';
		} else {
			$checked = (isset($attr['checked'])&&$attr['value']==$attr['checked'])?'checked="checked"':'';
		}		
		
		$html = '<div class="form-group '.$attr['class']['form-group'].'">'.
				'	<div class="checkbox">'.
				'		<label><input type="checkbox" name="'.$attr['name'].'" value="'.$attr['value'].'" '.$checked.' >'.
						$attr['label'].'</label>'.
				'	</div>'.
				'</div>';
		return $html;
	}
}


if ( ! function_exists('file_input_horizontal'))
{
	/**
	 * Text Input Field
	 *
	 * @param	name : Name attribute of the field
	 * @param	label : Label text for the field
	 * @param	value : Default value for the value field
	 * @param	class['form-group'] : Classes for input
	 * @param	class['form-group'] : Classes for form group
	 * @param	form-control-size : Size of input control
	 */
	function file_input_horizontal($attr)
	{
		$attr['form-control-size'] = (isset($attr['form-control-size']))? $attr['form-control-size']:'input-sm';
		$attr['class']['form-group'] = (isset($attr['class']['form-group']))? $attr['class']['form-group']:'';
		$attr['class']['control-label'] = (isset($attr['class']['control-label']))? $attr['class']['control-label']:'col-sm-3';
		$attr['class']['form-control'] = (isset($attr['class']['form-control']))? $attr['class']['form-control']:'col-sm-8';

		$html = '<div class="form-group '.$attr['class']['form-group'].'">';
		$html .= 	'<label class="control-label '.$attr['class']['control-label'].'" for="'.$attr['name'].'">'.$attr['label'].'</label>'.
					'<div class="'.$attr['class']['form-control'].'">';
		if(isset($attr['value']) && $attr['value']!=='') {
			$html .= 	'<img src="'.base_url('uploads/'.$attr['value']).'" class="img-responsive img-thumbnail" style="width:150px; height: auto;" >'.
						'<input type="hidden" name="old_'.$attr['name'].'" value="'.$attr['value'].'">';
		}
		$html .= 	'<input type="file" class="form-control '.$attr['form-control-size'].'" id="'.$attr['name'].
					'" name="'.$attr['name'].'">';
		$html .= 	'<span class="error">'.form_error($attr['name']) .'</span>'.
					'</div>';
        $html .= '</div>';

		return $html;
	}
}



if ( ! function_exists('form_submit'))
{
	/**
	 * Drop-down Menu
	 *
	 * @param	mixed	$data
	 * @param	mixed	$options
	 * @param	mixed	$selected
	 * @param	mixed	$extra
	 * @return	string
	 */
	function form_submit($attr=NULL)
	{
		$attr['style'] = (isset($attr['style']))? $attr['style']:'margin-left: 15px;';
		$attr['class'] = (isset($attr['class']))? $attr['class']:'btn-primary';
		$attr['value'] = (isset($attr['value']))? $attr['value']:'Submit';
		$attr['name'] = (isset($attr['name']))? 'name="'.$attr['name'].'"':'';
		$html = '<button '.$attr['name'].' style="'.$attr['style'].'" type="submit" class="btn btn-sm pull-right '.$attr['class'].'">'.$attr['value'].'</button>';
        return $html;		
	}
}

if ( ! function_exists('form_cancel'))
{
	/**
	 * Drop-down Menu
	 *
	 * @param	mixed	$data
	 * @param	mixed	$options
	 * @param	mixed	$selected
	 * @param	mixed	$extra
	 * @return	string
	 */
	function form_cancel($attr=NULL)
	{
		$attr['style'] = (isset($attr['style']))? $attr['style']:'';
		$attr['url'] = (isset($attr['url']))? $attr['url']:'javascript:void';
		$attr['class'] = (isset($attr['class']))? $attr['class']:'btn-default';
		$attr['value'] = (isset($attr['value']))? $attr['value']:'Cancel';
		$html = '<a style="'.$attr['style'].'" href="'.$attr['url'].'" class="btn btn-sm pull-right '.$attr['class'].'">'.$attr['value'].'</a>';
        return $html;		
	}
}