<?php defined('BASEPATH') OR exit('No direct script access allowed');

/**
* Menu Library
*/
class Menu 
{
	public $ci;

	public function __construct()
	{
		$this->ci = & get_instance();
	}

	public function getMainMenu(){

		$pages = $this->ci->db->get_where('page',array('page_level'=>0,'add_to_menu'=>'1'));
		$subPages = $this->ci->db->get_where('page',array('page_level'=>1,'add_to_menu'=>'1'));
		$navMenu = array();
		foreach($pages->result() as $page){
			if( $this->ci->auth->allowed_page_access($page) ) {
				if($page->page_url=='#'){
						$childLinks = array();
						foreach($subPages->result() as $subPage ){
							if( $this->ci->auth->allowed_page_access($subPage) ) {
								if($subPage->parent_page==$page->page_ID){
									array_push($childLinks,$subPage);
								}
							}
						}
						array_push($navMenu,(object)array(
							'type'=>'dropdown',
							'active'=> $this->isActive($page),
							'link'=> $page,
							'childLinks'=> $childLinks
						));
					} else {
						array_push($navMenu,(object)array(
							'type'=>'link',
							'active'=> $this->isActive($page),
							'link'=>$page
						));
				}
			}
		}
		return $navMenu;
	}


	public function getSideNav()
	{
		
		$requested_page = $this->ci->db->select('page_ID,parent_page')
					->where('page_url',current_page_url())
					->where('is_page_section','1')
					->get('page')->row();


		if($requested_page==NULL) {
			$requested_page = $this->ci->db->select('page_ID, parent_page')
					->where('page_url',current_page_url())
					->where('add_to_menu','0')
					->get('page')->row();
			
		} else {
			$requested_page = $this->ci->db->select('page_ID, parent_page')
					->where('page_ID',$requested_page->parent_page)
					->get('page')->row();
		}

		if($requested_page!==NULL && $requested_page->parent_page!=='') {
			$requested_page->page_ID = $requested_page->parent_page;
		}
		
		if($requested_page==NULL) {
			return false;
		}
		$sideNavPages  = $this->ci->db->get_where('page',array('page_level'=>1,'add_to_menu'=>'0','parent_page'=>$requested_page->page_ID))->result();
		return $sideNavPages;
	}

	public function getPageSections(){

		$requested_page = $this->ci->db->select('parent_page')
					->where('page_url',current_page_url())
					->where('is_page_section','1')
					->get('page')->row();
		$page_sections = array();

		if($requested_page!=NULL){
			$page_sections['data'] = $this->ci->db->get_where('page',array(
																	'parent_page'=>$requested_page->parent_page,
																	'is_page_section'=>'1'))->result();
			$page_sections['hidden_section'] = array();

			foreach($page_sections['data'] as $section) {
				if($section->exchange_section_with!=''){
					if(current_page_url()==$section->page_url) {
						array_push($page_sections['hidden_section'],$section->exchange_section_with);
					} else {
						array_push($page_sections['hidden_section'],$section->page_ID);
					}
				}
			}
			$page_sections['current_url'] = current_page_url();
		}
		return $page_sections;
	}

	protected function isActive ($link){
		if($link->page_url=='#'){
			$subPages = $this->ci->db->get_where('page',array('page_level'=>1,'parent_page'=>$link->page_ID));
			foreach ($subPages->result() as $page) {
				if($this->ci->router->class == $page->page_url){
					return true;
				}
			}
		}
		if($this->ci->router->class == $link->page_url){
			return true;
		}
		return false;
	}

}