<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Exam_Configuration_Model extends CI_Model{
    
    public $table = 'exam_config';
    
    public function __construct() {
        parent::__construct();
    }
    
    public function get( $examConfig_ID = NULL ){
        if($examConfig_ID==NULL){
                
            $query = $this->db->select('*')
                    ->from($this->table)                    
                    ->join('exam_standard',$this->table.'.exam_standard_ID=exam_standard.exam_standard_ID')
                    ->join('exam_org',$this->table.'.exam_org_ID=exam_org.exam_org_ID')
                    ->join('post_level',$this->table.'.post_level_ID=post_level.post_level_ID')
                    ->get();
            return $query->result();
        }
        $query = $this->db->select('*')
                    ->from($this->table)    
                    ->where($this->table.'.exam_config_ID', $examConfig_ID)                
                    ->join('exam_standard',$this->table.'.exam_standard_ID=exam_standard.exam_standard_ID')
                    ->join('exam_org',$this->table.'.exam_org_ID=exam_org.exam_org_ID')
                    ->join('post_level',$this->table.'.post_level_ID=post_level.post_level_ID')
                    ->get();
        return $query->row();
    }
    
    public function insert(){

        $subjects = array();

        if(isset($_POST['subjects'])){
            $subject_nos_ques = $this->input->post('subject_nos_ques');

            foreach($this->input->post('subjects') as $key => $subject){
                $subjects[$subject] = $subject_nos_ques[$key];
            }
        }

        $data = array(
                'exam_standard_ID' => $this->input->post('exam_standard_ID'),
                'exam_org_ID' => $this->input->post('exam_org_ID'),
                'post_level_ID' => $this->input->post('post_level_ID'),
                'exam_duration' => $this->input->post('exam_duration'),
                'nos_ques' => $this->input->post('nos_ques'),
                'subjects' => serialize($subjects)
                );

		return $this->db->insert($this->table,$data);
    }
    
    public function update(){
        $subjects = array();

        if(isset($_POST['subjects'])){
            $subject_nos_ques = $this->input->post('subject_nos_ques');

            foreach($this->input->post('subjects') as $key => $subject){
                $subjects[$subject] = $subject_nos_ques[$key];
            }
        }

        $data = array(
		    'exam_standard_ID' => $this->input->post('exam_standard_ID'),
            'exam_org_ID' => $this->input->post('exam_org_ID'),
            'post_level_ID' => $this->input->post('post_level_ID'),
            'exam_duration' => $this->input->post('exam_duration'),
            'nos_ques' => $this->input->post('nos_ques'),
            'subjects' => serialize($subjects)
		);
		$this->db->where('exam_config_ID', $this->input->post('exam_config_id'));
		return $this->db->update($this->table,$data);
    }  
    
    
    public function delete($exam_config_ID = NULL){
        return $this->db->delete( $this->table, array('exam_config_ID' => $exam_config_ID ));
    }
    
    /* Selected Value for exam org and post level */    
    public function selectedExamOrg($examStandardID = NULL){
        $query = $this->db->get_where( 'exam_org',array('exam_standard_ID' => $examStandardID));
        return $query->result();
    }
    public function selectedPostLevel($examOrgID = NULL){
        $query = $this->db->get_where( 'post_level',array('exam_org_ID' => $examOrgID));
        return $query->result();
    }

}
