<?php defined('BASEPATH') || exit('No direct script access allowed.');

/**
* Subscription Model
*/
class Subscription_Model extends CI_Model
{

	public $table = 'subscription';
	public $subscription_type = 'new';
	
	function __construct()
	{
		parent::__construct();

		$this->load->helper('date');
		$this->load->helper('array');
	}

	public function insert()
	{
		$datestring = '%Y-%m-%d';
		$time = time();


		$data = array(
			'user_ID' 				=> $this->input->post('student'),
			'subscription_pack_ID' 	=> $this->input->post('subscription_pack'),
			'subscription_type' 	=> $this->subscription_type,
			'valid_from'			=> mdate($datestring, $time),
			'question_pool'			=> $this->_getQuestionPool($this->input->post('subscription_pack'),$this->input->post('student')),
		);

		// print_r($data); die();

		return $this->db->insert($this->table,$data);
	}

	public function get($subscription_id = NULL)
	{
		if($subscription_id !== NULL) {
			$query = $this->db->get_where($this->table, array('subscription_ID' => $subscription_id));
			return $query->row();
		}
		$query = $this->db->get_where($this->table, array('subscription_type'=>'new'));
		return $this->_getGroupedSubscriptions($query->result());
	}

	public function renew($subscription_id){

		$datestring = '%Y-%m-%d';
		$time = time();
		$this->subscription_type = 'renewal';


		$data = array(
			'user_ID' 				=> $this->get($subscription_id)->user_ID,
			'subscription_pack_ID' 	=> $this->input->post('subscription_pack'),
			'subscription_type' 	=> $this->subscription_type,
			'valid_from'			=> mdate($datestring, $time),
			'parent_subscription'	=> $subscription_id,
			'question_pool'			=> $this->_getQuestionPool($this->input->post('subscription_pack'),$this->get($subscription_id)->user_ID)
		);

		return $this->db->insert($this->table,$data);

	}

	public function update()
	{
		$data = array(
			'subscription_pack_ID' 	=> $this->input->post('subscription_pack')
		);
		$this->db->where('subscription_ID', $this->input->post('subscription_id'));
		return $this->db->update($this->table, $data);
	}

	public function getSubscriptionByStudent($user_ID)
	{
		$query = $this->db->get_where($this->table, array('user_ID'=>$user_ID));
		return $query->row();
	}


	protected function _getGroupedSubscriptions($all_subscriptions){
		$grouped_subscription = array();
		foreach ($all_subscriptions as $subscription) {
			
			array_push($grouped_subscription,array(
				'parent' => $subscription,
				'renewals' => $this->db->get_where($this->table, array(
					'subscription_type'=>'renewal',
					'parent_subscription'=>$subscription->subscription_ID))->result(),
			));
		}
		return $grouped_subscription;

	}

	protected function _getQuestionPool($subscription_pack, $student_ID)
	{
		$subscription_pack_data = $this->db->get_where('subscription_packs', array('subscription_pack_ID'=>$subscription_pack))->row();
		$question_pool_constraints = explode(',',$subscription_pack_data->exam_standards);

		// $previous_subscriptions = $this->db->get_where($this->table,array(
		// 	'user_ID'				=> $student_ID,
		// 	'subscription_pack_ID' 	=> $subscription_pack
		// 	))->result();

		$previous_question_pool = array();


		// if(!empty($previous_subscriptions)){
		// 	$previous_assigned_questions = '';
		// 	foreach($previous_subscriptions as $subs){
		// 		$previous_assigned_questions .= $subs->question_pool .',';
		// 	}
		// 	$previous_question_pool = explode(',', rtrim($previous_assigned_questions, ','));
		// }


		$no_of_exams =  $subscription_pack_data->no_of_exams;

		$nos_ques_details = array();

		foreach($question_pool_constraints as $standard){
			$std = $this->db->order_by('nos_ques','DESC')
							->get_where('exam_config', array('exam_standard_ID' => $standard))->row();
			if($std){
				$nos_ques_details[$standard] = unserialize($std->subjects);
			}
		}


		$question_pool = $nos_ques_details;

		foreach($nos_ques_details as $exam_standard => $subjects){
			foreach($subjects as $subject => $subject_nos_ques){
				$subject_nos_ques = ($subject_nos_ques * $no_of_exams) + $subject_nos_ques;

				$subject_ques_array = $this->db->select('question_ID')
												->where('exam_standard_ID',$exam_standard)
												->where('subject_ID',$subject)
												->limit($subject_nos_ques)
												->order_by('question_ID','RANDOM')
												->get('questions')->result();

				$subject_questions = array();
				foreach($subject_ques_array as $ques){
					$subject_questions[] = $ques->question_ID;
				}

				$question_pool[$exam_standard][$subject] = implode(',',$subject_questions);
			}
		}

		return serialize($question_pool);
	}
}