<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>

<br/>
<div class="row">
<div class="col-md-6">
    <div class="panel panel-default">
        <div class="panel-body">
        <?php echo form_open('exam_configuration/update'); ?> 
        <?php echo hidden_input(array('name'=>'exam_config_id','value'=>$exam_configuration->exam_config_ID)); ?>
        <?php        
        $options = array();        
        foreach($exam_standards as $exam_standard) :
            $options[$exam_standard->exam_standard_ID] = $exam_standard->standard_name;
        endforeach;        
        echo form_dropdown(array(
                            'name'=>'exam_standard_ID',
                            'label'=>'Exam Standard :',
                            'options'=> $options,
                            'placeholder'=> 'Select a Exam Standard',
                            'selected' =>$exam_configuration->exam_standard_ID
                          ));
        ?>
        <?php        
        $options=array();        
        foreach($exam_organisations as $exam_organisation) :
            $options[$exam_organisation->exam_org_ID] = $exam_organisation->exam_org_name;
        endforeach;        
        echo form_dropdown(array(
                            'name'=>'exam_org_ID',
                            'label'=>'Exam Organisation :',
                            'options'=> $options,
                            'placeholder'=> 'Select a Exam Organisation',
                            'selected' =>$exam_configuration->exam_org_ID
                          ));
        ?>
        <?php        
        $options=array();        
        foreach($post_levels as $post_level) :
            $options[$post_level->post_level_ID] = $post_level->post_level_name;
        endforeach;        
        echo form_dropdown(array(
                            'name'=>'post_level_ID',
                            'label'=>'Post Level :',
                            'options'=> $options,
                            'placeholder'=> 'Select a Post Level',
                            'selected' =>$exam_configuration->post_level_ID
                          ));
        ?>
        <?php echo form_input(array('name'=>'exam_duration','label'=>'Exam Duration (in Mins.) :','value'=>$exam_configuration->exam_duration)); ?>
        <?php echo form_input(array('name'=>'nos_ques','label'=>'Total No. of Questions per Exam :','value'=>$exam_configuration->nos_ques)); ?>
        <fieldset>
          <legend>Subjects :</legend>
          <a href="<?= base_url('exam_configuration/') ?>add_subject" data-toggle="modal" data-target="#ajax-modal" class="btn btn-success btn-sm pull-right ajax" data-replace="#ajax-form-container">
            <span class="fa fa-plus"></span> Add New Subject
          </a>
          <table class="table table-striped">
            <thead>
              <tr>
                <th>Subject</th>
                <th><div data-toggle="tooltip" data-placement="top" data-original-title="No. of Questions to include from this Subject" >
                  No. of Questions
                  </div>
                </th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody id="subject-list">
            <?php
            if($exam_configuration->subjects !== ''):
             foreach(unserialize($exam_configuration->subjects) as $subject_ID => $nos_ques ):
                  $subject = "";
                  foreach($subjects as $sub){
                    if($sub->subject_ID == $subject_ID){
                      $subject = $sub;
                    }
                  }
            ?>
              <tr>
                <td>
                  <?= hidden_input(array('name' => 'subjects[]', 'value' => $subject->subject_ID));  ?>
                  <?= $subject->subject_name ?>
                </td>
                <td>
                    <?= $nos_ques ?>
                    <?= hidden_input(array('name' => 'subject_nos_ques[]', 'value' => $nos_ques));  ?>
                </td>
                <td>
                    <a class="btn btn-danger btn-sm remove-item" data-toggle="tooltip" data-placement="top" data-original-title="Remove">
                        <span class="fa fa-close"></span>
                    </a>
                </td>
              </tr>
            <?php endforeach;
            endif;
             ?>
            </tbody>
          </table>
        </fieldset>
        <br>
        <?php echo form_submit(array('value'=>'Save', 'class'=>'btn-success')); ?>
        <?php echo form_close(); ?>
    </div>
    </div>
</div>
</div> 

<!-- Modal -->
<div id="ajax-modal" class="modal fade" role="dialog">
  <div class="modal-dialog" >
    <div class="modal-content">
    <div id="ajax-form-container">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title"></h4>
      </div>
      <div class="modal-body">
        <p>Loading...</p>
      </div>
      <div class="modal-footer">
      </div>
    </div>
    </div>
  </div>
</div>


<script>
    $(document).ready(function(){   
        
    // Selected exam organization list    
    $('#exam_standard_ID').on('change',function(){
      var examStandardID = $(this).find('option:selected').val();  
      var url = '<?php echo base_url('exam_duration/selectExamOrg/'); ?>'+ examStandardID;
        $.getJSON(url,function(data){
           if(data){
              var options ="<option value=''>Select a Exam Organisation</option>\n";
              $.each(data,function(i,val){
                   
                   options += "<option value='"+val.exam_org_ID +"'>"+val.exam_org_name+"</option>\n";
                   
               });
               
              $('#exam_org_ID').html(options);
           }
        });
    });    
    
     // Selected post level list    
    $('#exam_org_ID').on('change',function(){
      var examOrgID = $(this).find('option:selected').val();  
      var url = '<?php echo base_url('exam_duration/selectPostLevel/'); ?>'+ examOrgID;
        $.getJSON(url,function(data){
           if(data){
              var options ="<option value=''>Select a Post Level</option>\n";
              $.each(data,function(i,val){
                   
                   options += "<option value='"+val.post_level_ID +"'>"+val.post_level_name+"</option>\n";
                   
               });
               
              $('#post_level_ID').html(options);
           }
        });
    });
});
</script>
